from hamcrest import assert_that, equal_to
from datacloud.features.cluster import clust_features


class TestHostNameBowReducer(object):
    def test_counters(self):
        key = 'external_id'
        input_records = [
            {
                'external_id': '1',
                'counter': 1,
                'host': 'europaplus.ru',
                'timestamp': 1488644503
            },
            {
                'external_id': '1',
                'counter': 3,
                'host': 'yandex.ru',
                'timestamp': 148864603
            },
            {
                'external_id': '1',
                'counter': 5,
                'host': 'europaplus.ru',
                'timestamp': 148864903
            },
        ]
        result_records = list(clust_features.HostnameBowReducer(key)({key: '1'}, input_records))
        expected_records = [
            {'external_id': '1', 'host': 'yandex.ru', 'counter': 3},
            {'external_id': '1', 'host': 'europaplus.ru', 'counter': 6},
        ]
        assert_that(expected_records, equal_to(result_records))


# switched to C++
# class TestAppendHostVectorReducer(unittest.TestCase):
#     def test_small_data(self):
#         first_input = [
#             {
#                 'host': 'test-host.ru',
#                 'vector_b': du.array_tostring([1, 2, 3, 4, 5]),
#                 'vector_m': du.array_tostring([6, 7, 8, 9, 10])
#             }
#         ]
#         second_input = [
#             {
#                 'host': 'test-host.ru',
#                 'key': 'first-cid(TRASH)'
#             },
#             {
#                 'host': 'test-host.ru',
#                 'key': 'second-cid(TRASH)'
#             }
#         ]
#         reducer = clust_features.AppendHostVectorReducer()
#         context = FakeContext()
#         generator = RecordsGenerator([first_input, second_input], context)
#
#         result_records = list(reducer({'host': 'test-host.ru'}, generator, context))
#         expected_records = [
#             {
#                 'key': 'first-cid(TRASH)',
#                 'host': 'test-host.ru',
#                 'vector': '\x00\x00\x80?\x00\x00\x00@\x00\x00@@\x00\x00\x80@\x00\x00\xa0@\x00\x00\xc0@\x00\x00\xe0@\x00\x00\x00A\x00\x00\x10A\x00\x00 A'  # noqa
#             },
#             {
#                 'key': 'second-cid(TRASH)',
#                 'host': 'test-host.ru',
#                 'vector': '\x00\x00\x80?\x00\x00\x00@\x00\x00@@\x00\x00\x80@\x00\x00\xa0@\x00\x00\xc0@\x00\x00\xe0@\x00\x00\x00A\x00\x00\x10A\x00\x00 A'  # noqa
#             }
#         ]
#         self.assertEqual(expected_records, result_records)
#
#     def test_real_data(self):
#         first_input = [
#             {
#                 'host': 'test-host.ru',
#                 'vector_b': 'Y\xccc?\x8aKt\xbf/\xe1\xa6\xbe2K\x1a\xbf\x1e,\x89>\xfb\xe0\xcc\xbd6\xba\xc0\xbe\xc2\r\x01\xbd\xa5\xb0\x0c?TV\x0f\xbf2\xa4\xff>az\xce\xbeD\x80=?\x9d\xc9\xc5\xbd\xb1\xd2\xaa\xbf\xfa\xe9!\xbf?\xf0\x0e>\x11\xbc\x85>\x8b\xbcl\xbd\x0c\x004>B\xd9@<\xb0\xf7\xb6\xbe\x147\xb0=\xa1W\x04\xbf\xca\xaf\xa4\xbc\x97\xd9%>Oq{>\x9a\xfb\x8d?+\xb3P\xbe\t\xfe0\xbd\xfce\xe2\xbe\xe7\x95\xe8\xbe\x1b8\x85>\x82\'\x11\xbf\x07\xe4\xf8\xbe\x8fn\x1a?\xb9\xf0@\xbf0\x1d\xb4>\x02o\x8e>n\x06\x8e>\x87)\xec?z\xe6\x8d\xbe\x12A1?}U\x84?\xa2\xc8f>\xb1\x01\xbb>W\t\xfc\xbe\xdb\xa1Q\xbf\xe4\x02\xf4\xbe\x85\xe5:?\xef\x95\x0c\xbf>\x1ag?\xe4\x8e\x8d?\xeb\x99M\xbevD\x9c?Iad\xbc\xd9g\xa4\xbd\xd8\xd6e>\x9bp\x98\xbd\x92\xf1\xc2>U\xb3@\xbf.Z\xa4<\x11\xa6W?[4\x0e?a\x9b=?\x05\xb8\x03?Y\xe4\xc7> T\x0e\xbd\'\xb0\x9e<<\xb7\x85?f\xd3\xe5>\x1f_\xdb\xbe\x91\x027?\x8c\x01\xa5>\x87\x03\x15\xbf9N)\xbe\xf9\x94\xa9\xbc\x90\x1b\xe0\xbeq\x87\xd8\xbe|)\x90>\x9co4\xbf\x8a\xfa\xd2\xbeAJ\xc6>\x00Y\x04?\x7f\xf5\x93>\xdb-\xf7\xbd\x9e\xac\xbe>\x99v%\xbf]Ck=\xfe\x80 \xbf\x0b\xa7\xe5\xbe_\xf6\x02\xbf\xc5\x11n?\x89)m\xbe\xd69t?\xbah]\xbe\x93"W\xbfNJ\xb6>\xd7\xafy\xbe\xa5\x85\xf8=\xc29(\xbe\xf5C)\xbf\x9a~\xc2<H\xdd\x90?\xb5\xa6\x12\xbf\xc8\x8d\xe1\xbe\x02\xc0\x1d\xbe\x9d\xc3\xf8\xbeg\xa1\x97\xbdk\xcc\x0b?h\xc52\xbfb8\x0f>\xa1\xcaJ\xbf\xeb\xa8\\?\xa5\xfc\xbe>\xbf\x05Z?(\xd8\xdd=\xda.\x1a\xbcR4\x05?\x07I\xa6\xbe\xec\xb2\xad?\xc1*[\xbe\x88@\r>\xc3\x1c\x9a?\xf2\xa7\x0b?\xf2\t\x02\xbf{\xb9j\xbf\x17s\x0b\xbc\x0f\x9f\x8f=6\x83g=\xc0\xe9\xc0>R\xe6\x8f?\xd9d\xc4\xbebx]\xbf7\x0bV>O\xd5\xd8>F\x9a@\xbfW\xee(?\xf7,$\xbf\x95b\x99\xbd\x8dn\xac>\xfe\xbc\xec;\xaa\xc3\xa7\xbe\x7fs\xcb=\xbd\x81\xab?p\x04S\xbf\xfbCR\xbf+\x06X\xbe`_\x85?X\x83\xfc\xbe\x1d\xcf\xd3\xbe\xbbX\x15\xbea\xae6?\xbb\x9aQ\xbe}GY?\xbe\xe3\xa3?\xf1\xf7\x8c\xbf\xa5\xb8\xbd\xbe\x16u\xe5=\x15\x9dw\xbfd.\x89?\x1b\xa3f\xbf\xb6\xe9M?&\xbd4>`\x9c\x89?\x05\x11*\xbffz\x8b\xbf\x91\x1eX?(\x81>>\xf7\xe8\xf1>\xf0Q\x02\xbe\xbe \xa2\xbe\xedX?>\xbah\xd8>Z\x9b\x84\xbe\xe9\xec\x90\xbe\xf0\x81\x92>~\xce\x0b\xbf\xd5\xf17?\xcd\xe3\xf7>\xa2\r\x08\xbf\xe805\xbdG\xc0\x98>\xaeC\xf3>\xf9\xb8\xde\xbe\xc3\xa3\xb6\xbel\xac\x88?\xbc\'\x91\xbd\x14\x88\x83>\t\xbe\r>\xc3`\xfd\xbe8\xbaI>\xd4\xf2\xef\xbf\x9aV\x82?\xa8\xb9\xec>4x\x1b?\xaa\xd0\xed;\x9dw\x8a\xbe\xcd\xd9$?\xab\xb1\x1e\xbf\xcax\x97>Fr9\xbf/"Y\xbf\xb0h\xe1>\xdd\x06\xb7\xbe\xe5c??\t:\xca>\x17\x94\x1d>\x8f\x8cw?\xed\xafI\xbf\xdeS\x90>\xcd\x94\x9c>\x19"6?\x94\xe2\x00\xbf\xee\x9b\xc4\xbe\xf4\xf9\xc7\xbe\\\xdd\xcb\xbf\xbf\xe0\x0e\xbf\x97\xbb6\xbe03e>A9y\xbcU\xb2\x84\xbd`R\x81\xbeP@A?\xae\xcd"?\x89ZU>\x9cG\x0c?VC\xc0?\xa7t!\xbf.\x9c\x8d\xbeD\x02 \xbe\xe66\x04\xbf\xa4IV\xbf\xef\xce\xd0\xbe\x15<\r>u\xbf\xaa\xbe>\x0cF?\xa7\r\x85>\xcc\x0c\x9a\xbe1\x15\xff\xbc\x11c\'\xbfE\xc8\xa2?\xef\xee\xe9\xbe\xbf\x968\xbf\x07\x13\x0e=x\xd7\x00\xbf\xfb=\xae\xbf\xc0\xeda?\x9e\x1d\x86\xbe\x13\xa5\x80?\xe9w\x87\xbe>PF\xbeF\xe7)>6\xd1\xe4\xbe`o\x04\xbe\x7f\xb0R>',  # noqa
#                 'vector_m': 'Q\x0b\xa0\xbf\xf8\x9f\xbd\xbf\xbd\x97 @E\x99\xa8\xbf\x8c\x84\x11>Ms\xc6>\xeaq\xc8\xbf\xd8%+>|\xcb\x9f\xbf\xcfW\xb9\xbd\x95\xd5O\xbf.\xc6\x08\xbf\x0eY\x10?ob\xef>\xd6\xad\xb6\xbfd\xbcZ\xbe__\xcc\xbfQ\xab;>\x9f\xc1\x00\xbf\xf7\xc9\x85?\x9d>\x9a>\xb6;4<\xfd\xf1\x8d\xbfQ:\x07?\xb2\xc0?\xbf\xda\x97\xbf>u\xe6v?&\xc2\x87\xbf\x85\xbd\xec\xbe\xdf\x9a\xde\xbe\r\xd95\xbf\xa9\xa4\xe1?\xead\xc5\xbf\x0f\x88\x0f\xc0\x86M\x06>\xb9v\xfc\xbe\xacb\x90>-h\x98\xbf\x07\xdd\x1f\xbfN\x9f\x15?\\XA?<v\x1c>\xaaz\xaa?\xcc\tt?\xe5\xe5\xcb=1Z\xa3\xbeC\x15\xec\xbf\xe5\xed\xb0\xbe\x08q\xc5\xbe\xac\xbf\x8b?\xf3U]\xbf\xa9\x8e\x90?\xad\xbc\xb6>]d\xd0?i\xb1\xd8>\x89X\xaf>>\xf9a\xbf\xafh\xd6\xbf{\x7f\xbe>\xc8\xfe\xd9\xbd\\\xdb\xd4>\xcfS\x0f\xbf\xc1\xce^\xbd\xdb\xda\x11\xbfV\xf3\xa3?\xc3u\x97\xbf\x1d K?\xe4\xf6\xeb\xbe\xc5)\x0e\xc0#\xbfe\xbfW\x8a\xae?\x07\x06\xfa\xbd\xaf\xa4\xf3\xbd\xfe\x86\xf1=\xcc%\xaa?\x18\xdb\x01\xc0Kuu?\xfc&L\xbf\xcc\xde\xa6\xbf\xce\xe7\x9b\xbe\x91\xe9\xc4>\xe7hm\xbe\x83\xc3\xa8\xbf\x03\xf7\xe7\xbf1R\xdb\xbf1\x03i\xbf\xd8\xd8\x07\xbf*,\xd9\xbfz\x0b\xa3?wu\x19\xbf \xabI?\x04\xfa\x9b?\xa5\xf67?\xe6i\xb4\xbf\xe4\xed\xf0=\xdd\xd7\x1a?\xed$!\xbet(\xcc\xbe:\xd55?\x7fY\x8e>\xe4\xabE\xbf&\xcfy\xbe\xcdk\x97?ql\xfc\xbd8F\x82?>*\xee>D\x0b\x05?\xb0\xac\xba\xbd5>\t\xbfJ\x9d\x8a>\x81\xf3\x1f?\xa1\xb6\xf5>\xd7\xeaC\xbf\xe2UV\xbe:\xf7\x1d?\x83t>?\xcbo\xbf=O\x07\xfc\xbe\x8b\xedJ\xbe\x0f\xc7=\xbfbF\x06?\x9a\xf0\xae\xbf\xb7\nb>2\x17\xda\xbdy_\xff\xbe\xe3\xe8N?\xe2\xd4\xe0?\xdcQ\xcd;\xb7\xf8\xe6>\xabx\xa3<L\xb6\x96=\x8b)\x7f>\xc8\xfe\x8d\xbe\x81\x18\x05@\xf6\x85\xa3?\xdcA\xbc?\xb5\xd9\xe4\xbe%c\x1f?\xc9\x7f[>=v\xc3\xbc\xf4\xb4o\xbf\xc5\rl\xbf\xc9F7\xbf\x14\xa4\x8f\xbf\x1fX\xc3>F\xa0\xe9\xbf\x1f]\xdc>\xce\xd6\x19\xbfH4t>5[\x04\xbf9`\xfa>\x0f\xb1\xeb\xbfib\\\xbf\xa7\xbc3>\xe3p\x07?\xc6\x10\xb8\xbdn\xb6\x15?u\x96\x86\xbf\x0b\xd91\xbf\xcc\x05\x83\xbeQ\x90q?;\x88\xbd\xbf\xb7g!?\x04D\xa8>\x00\x8f\xa6\xbfIm8?\x19\x83%\xbf,\x02\x99\xbf\xcb\xa2\x81>\x06\xf1\xe6>\x99\xbf\x81\xbe\xa1\xfca?d>\xb9\xbe\x81\x17\r\xbf\xc9\x03\x84;7\xa3&\xbe\x8a55?z\xed}\xbef\xcd\x07<v\xa22?\xac\xd9G?\x87\x1bi\xbf\x9eCX\xbfi\xccg>l\x1f\x01>\x00\xfal?\xee\rA\xbf\xf0\xc1"\xbfk2m?\xc1\xe8\xfa\xbe/\xf6 \xbe\xb0\xaa\xbc?8{J\xbe\x0b\x10\xce=\x8b\xc6\xf7\xbdmv7?\xf4R\x82\xbd\xad\xda\xed?8\x07\x92:X\xc7\xee?Y\xbc \xbf\xa9\x8c\xb2>\xd1\xaaP?[\x13|\xbf9\x13\x1c?\x10\xe4\x19\xbf5.A\xbf\xba\xb3\x0e\xbf\x86\x85\xea>)a\xb2?\xec\xc5\x9b\xbeY\xae#?\xc5-v?y\xba\xe2?\xdd\x82=\xbf\xc9\xee\xbd\xbd\xe7J\x17\xbe\xb7&@?\xd1,/?8b\xb4>\xe2\xc6e?\xff_\x86?\xdf)O?i%/<\x0e\x80Z\xbft\x17\x81?\xab\xa2\xee\xbf\xaa\xa0y?\x84\xc7\xff\xbd\xd4\x08\xc8\xbe\x0c\xf9M\xbc\x9a#\xc0?\x9fx\x18@\xb7\xbe\xa2>\x1c\x88\x8d\xbf\xd0\x92\x1c>\x15\xa5\xac\xbf\x1e\xb4\x94>IP\xc0\xbfa\xfeN?\x94\xfc\xcb\xbf\x1bl\xae\xbf\\J\xdf>/.h>\xd5\x05\x86\xbf1\xf8\x0e\xbf\x8d4\x18?0\x16\x8e\xbfji\xdf?\x15\x14\x80\xbf\xd4/Z\xbfA\x1e\x93?\x19\xb7\xc1\xbf\xe0\xed\xc2\xbe\x82\xd7\xc4\xbf\x91jI?'  # noqa
#             }
#         ]
#         second_input = [
#             {
#                 'host': 'test-host.ru',
#                 'key': '1234567891234566789(YANDEXUID)'
#             }
#         ]
#         reducer = clust_features.AppendHostVectorReducer()
#         context = FakeContext()
#         generator = RecordsGenerator([first_input, second_input], context)
#
#         result_records = list(reducer({'host': 'test-host.ru'}, generator, context))
#         expected_records = [
#             {
#                 'host': 'test-host.ru',
#                 'key': '1234567891234566789(YANDEXUID)',
#                 'vector': 'Y\xccc?\x8aKt\xbf/\xe1\xa6\xbe2K\x1a\xbf\x1e,\x89>\xfb\xe0\xcc\xbd6\xba\xc0\xbe\xc2\r\x01\xbd\xa5\xb0\x0c?TV\x0f\xbf2\xa4\xff>az\xce\xbeD\x80=?\x9d\xc9\xc5\xbd\xb1\xd2\xaa\xbf\xfa\xe9!\xbf?\xf0\x0e>\x11\xbc\x85>\x8b\xbcl\xbd\x0c\x004>B\xd9@<\xb0\xf7\xb6\xbe\x147\xb0=\xa1W\x04\xbf\xca\xaf\xa4\xbc\x97\xd9%>Oq{>\x9a\xfb\x8d?+\xb3P\xbe\t\xfe0\xbd\xfce\xe2\xbe\xe7\x95\xe8\xbe\x1b8\x85>\x82\'\x11\xbf\x07\xe4\xf8\xbe\x8fn\x1a?\xb9\xf0@\xbf0\x1d\xb4>\x02o\x8e>n\x06\x8e>\x87)\xec?z\xe6\x8d\xbe\x12A1?}U\x84?\xa2\xc8f>\xb1\x01\xbb>W\t\xfc\xbe\xdb\xa1Q\xbf\xe4\x02\xf4\xbe\x85\xe5:?\xef\x95\x0c\xbf>\x1ag?\xe4\x8e\x8d?\xeb\x99M\xbevD\x9c?Iad\xbc\xd9g\xa4\xbd\xd8\xd6e>\x9bp\x98\xbd\x92\xf1\xc2>U\xb3@\xbf.Z\xa4<\x11\xa6W?[4\x0e?a\x9b=?\x05\xb8\x03?Y\xe4\xc7> T\x0e\xbd\'\xb0\x9e<<\xb7\x85?f\xd3\xe5>\x1f_\xdb\xbe\x91\x027?\x8c\x01\xa5>\x87\x03\x15\xbf9N)\xbe\xf9\x94\xa9\xbc\x90\x1b\xe0\xbeq\x87\xd8\xbe|)\x90>\x9co4\xbf\x8a\xfa\xd2\xbeAJ\xc6>\x00Y\x04?\x7f\xf5\x93>\xdb-\xf7\xbd\x9e\xac\xbe>\x99v%\xbf]Ck=\xfe\x80 \xbf\x0b\xa7\xe5\xbe_\xf6\x02\xbf\xc5\x11n?\x89)m\xbe\xd69t?\xbah]\xbe\x93"W\xbfNJ\xb6>\xd7\xafy\xbe\xa5\x85\xf8=\xc29(\xbe\xf5C)\xbf\x9a~\xc2<H\xdd\x90?\xb5\xa6\x12\xbf\xc8\x8d\xe1\xbe\x02\xc0\x1d\xbe\x9d\xc3\xf8\xbeg\xa1\x97\xbdk\xcc\x0b?h\xc52\xbfb8\x0f>\xa1\xcaJ\xbf\xeb\xa8\\?\xa5\xfc\xbe>\xbf\x05Z?(\xd8\xdd=\xda.\x1a\xbcR4\x05?\x07I\xa6\xbe\xec\xb2\xad?\xc1*[\xbe\x88@\r>\xc3\x1c\x9a?\xf2\xa7\x0b?\xf2\t\x02\xbf{\xb9j\xbf\x17s\x0b\xbc\x0f\x9f\x8f=6\x83g=\xc0\xe9\xc0>R\xe6\x8f?\xd9d\xc4\xbebx]\xbf7\x0bV>O\xd5\xd8>F\x9a@\xbfW\xee(?\xf7,$\xbf\x95b\x99\xbd\x8dn\xac>\xfe\xbc\xec;\xaa\xc3\xa7\xbe\x7fs\xcb=\xbd\x81\xab?p\x04S\xbf\xfbCR\xbf+\x06X\xbe`_\x85?X\x83\xfc\xbe\x1d\xcf\xd3\xbe\xbbX\x15\xbea\xae6?\xbb\x9aQ\xbe}GY?\xbe\xe3\xa3?\xf1\xf7\x8c\xbf\xa5\xb8\xbd\xbe\x16u\xe5=\x15\x9dw\xbfd.\x89?\x1b\xa3f\xbf\xb6\xe9M?&\xbd4>`\x9c\x89?\x05\x11*\xbffz\x8b\xbf\x91\x1eX?(\x81>>\xf7\xe8\xf1>\xf0Q\x02\xbe\xbe \xa2\xbe\xedX?>\xbah\xd8>Z\x9b\x84\xbe\xe9\xec\x90\xbe\xf0\x81\x92>~\xce\x0b\xbf\xd5\xf17?\xcd\xe3\xf7>\xa2\r\x08\xbf\xe805\xbdG\xc0\x98>\xaeC\xf3>\xf9\xb8\xde\xbe\xc3\xa3\xb6\xbel\xac\x88?\xbc\'\x91\xbd\x14\x88\x83>\t\xbe\r>\xc3`\xfd\xbe8\xbaI>\xd4\xf2\xef\xbf\x9aV\x82?\xa8\xb9\xec>4x\x1b?\xaa\xd0\xed;\x9dw\x8a\xbe\xcd\xd9$?\xab\xb1\x1e\xbf\xcax\x97>Fr9\xbf/"Y\xbf\xb0h\xe1>\xdd\x06\xb7\xbe\xe5c??\t:\xca>\x17\x94\x1d>\x8f\x8cw?\xed\xafI\xbf\xdeS\x90>\xcd\x94\x9c>\x19"6?\x94\xe2\x00\xbf\xee\x9b\xc4\xbe\xf4\xf9\xc7\xbe\\\xdd\xcb\xbf\xbf\xe0\x0e\xbf\x97\xbb6\xbe03e>A9y\xbcU\xb2\x84\xbd`R\x81\xbeP@A?\xae\xcd"?\x89ZU>\x9cG\x0c?VC\xc0?\xa7t!\xbf.\x9c\x8d\xbeD\x02 \xbe\xe66\x04\xbf\xa4IV\xbf\xef\xce\xd0\xbe\x15<\r>u\xbf\xaa\xbe>\x0cF?\xa7\r\x85>\xcc\x0c\x9a\xbe1\x15\xff\xbc\x11c\'\xbfE\xc8\xa2?\xef\xee\xe9\xbe\xbf\x968\xbf\x07\x13\x0e=x\xd7\x00\xbf\xfb=\xae\xbf\xc0\xeda?\x9e\x1d\x86\xbe\x13\xa5\x80?\xe9w\x87\xbe>PF\xbeF\xe7)>6\xd1\xe4\xbe`o\x04\xbe\x7f\xb0R>Q\x0b\xa0\xbf\xf8\x9f\xbd\xbf\xbd\x97 @E\x99\xa8\xbf\x8c\x84\x11>Ms\xc6>\xeaq\xc8\xbf\xd8%+>|\xcb\x9f\xbf\xcfW\xb9\xbd\x95\xd5O\xbf.\xc6\x08\xbf\x0eY\x10?ob\xef>\xd6\xad\xb6\xbfd\xbcZ\xbe__\xcc\xbfQ\xab;>\x9f\xc1\x00\xbf\xf7\xc9\x85?\x9d>\x9a>\xb6;4<\xfd\xf1\x8d\xbfQ:\x07?\xb2\xc0?\xbf\xda\x97\xbf>u\xe6v?&\xc2\x87\xbf\x85\xbd\xec\xbe\xdf\x9a\xde\xbe\r\xd95\xbf\xa9\xa4\xe1?\xead\xc5\xbf\x0f\x88\x0f\xc0\x86M\x06>\xb9v\xfc\xbe\xacb\x90>-h\x98\xbf\x07\xdd\x1f\xbfN\x9f\x15?\\XA?<v\x1c>\xaaz\xaa?\xcc\tt?\xe5\xe5\xcb=1Z\xa3\xbeC\x15\xec\xbf\xe5\xed\xb0\xbe\x08q\xc5\xbe\xac\xbf\x8b?\xf3U]\xbf\xa9\x8e\x90?\xad\xbc\xb6>]d\xd0?i\xb1\xd8>\x89X\xaf>>\xf9a\xbf\xafh\xd6\xbf{\x7f\xbe>\xc8\xfe\xd9\xbd\\\xdb\xd4>\xcfS\x0f\xbf\xc1\xce^\xbd\xdb\xda\x11\xbfV\xf3\xa3?\xc3u\x97\xbf\x1d K?\xe4\xf6\xeb\xbe\xc5)\x0e\xc0#\xbfe\xbfW\x8a\xae?\x07\x06\xfa\xbd\xaf\xa4\xf3\xbd\xfe\x86\xf1=\xcc%\xaa?\x18\xdb\x01\xc0Kuu?\xfc&L\xbf\xcc\xde\xa6\xbf\xce\xe7\x9b\xbe\x91\xe9\xc4>\xe7hm\xbe\x83\xc3\xa8\xbf\x03\xf7\xe7\xbf1R\xdb\xbf1\x03i\xbf\xd8\xd8\x07\xbf*,\xd9\xbfz\x0b\xa3?wu\x19\xbf \xabI?\x04\xfa\x9b?\xa5\xf67?\xe6i\xb4\xbf\xe4\xed\xf0=\xdd\xd7\x1a?\xed$!\xbet(\xcc\xbe:\xd55?\x7fY\x8e>\xe4\xabE\xbf&\xcfy\xbe\xcdk\x97?ql\xfc\xbd8F\x82?>*\xee>D\x0b\x05?\xb0\xac\xba\xbd5>\t\xbfJ\x9d\x8a>\x81\xf3\x1f?\xa1\xb6\xf5>\xd7\xeaC\xbf\xe2UV\xbe:\xf7\x1d?\x83t>?\xcbo\xbf=O\x07\xfc\xbe\x8b\xedJ\xbe\x0f\xc7=\xbfbF\x06?\x9a\xf0\xae\xbf\xb7\nb>2\x17\xda\xbdy_\xff\xbe\xe3\xe8N?\xe2\xd4\xe0?\xdcQ\xcd;\xb7\xf8\xe6>\xabx\xa3<L\xb6\x96=\x8b)\x7f>\xc8\xfe\x8d\xbe\x81\x18\x05@\xf6\x85\xa3?\xdcA\xbc?\xb5\xd9\xe4\xbe%c\x1f?\xc9\x7f[>=v\xc3\xbc\xf4\xb4o\xbf\xc5\rl\xbf\xc9F7\xbf\x14\xa4\x8f\xbf\x1fX\xc3>F\xa0\xe9\xbf\x1f]\xdc>\xce\xd6\x19\xbfH4t>5[\x04\xbf9`\xfa>\x0f\xb1\xeb\xbfib\\\xbf\xa7\xbc3>\xe3p\x07?\xc6\x10\xb8\xbdn\xb6\x15?u\x96\x86\xbf\x0b\xd91\xbf\xcc\x05\x83\xbeQ\x90q?;\x88\xbd\xbf\xb7g!?\x04D\xa8>\x00\x8f\xa6\xbfIm8?\x19\x83%\xbf,\x02\x99\xbf\xcb\xa2\x81>\x06\xf1\xe6>\x99\xbf\x81\xbe\xa1\xfca?d>\xb9\xbe\x81\x17\r\xbf\xc9\x03\x84;7\xa3&\xbe\x8a55?z\xed}\xbef\xcd\x07<v\xa22?\xac\xd9G?\x87\x1bi\xbf\x9eCX\xbfi\xccg>l\x1f\x01>\x00\xfal?\xee\rA\xbf\xf0\xc1"\xbfk2m?\xc1\xe8\xfa\xbe/\xf6 \xbe\xb0\xaa\xbc?8{J\xbe\x0b\x10\xce=\x8b\xc6\xf7\xbdmv7?\xf4R\x82\xbd\xad\xda\xed?8\x07\x92:X\xc7\xee?Y\xbc \xbf\xa9\x8c\xb2>\xd1\xaaP?[\x13|\xbf9\x13\x1c?\x10\xe4\x19\xbf5.A\xbf\xba\xb3\x0e\xbf\x86\x85\xea>)a\xb2?\xec\xc5\x9b\xbeY\xae#?\xc5-v?y\xba\xe2?\xdd\x82=\xbf\xc9\xee\xbd\xbd\xe7J\x17\xbe\xb7&@?\xd1,/?8b\xb4>\xe2\xc6e?\xff_\x86?\xdf)O?i%/<\x0e\x80Z\xbft\x17\x81?\xab\xa2\xee\xbf\xaa\xa0y?\x84\xc7\xff\xbd\xd4\x08\xc8\xbe\x0c\xf9M\xbc\x9a#\xc0?\x9fx\x18@\xb7\xbe\xa2>\x1c\x88\x8d\xbf\xd0\x92\x1c>\x15\xa5\xac\xbf\x1e\xb4\x94>IP\xc0\xbfa\xfeN?\x94\xfc\xcb\xbf\x1bl\xae\xbf\\J\xdf>/.h>\xd5\x05\x86\xbf1\xf8\x0e\xbf\x8d4\x18?0\x16\x8e\xbfji\xdf?\x15\x14\x80\xbf\xd4/Z\xbfA\x1e\x93?\x19\xb7\xc1\xbf\xe0\xed\xc2\xbe\x82\xd7\xc4\xbf\x91jI?'  # noqa
#             }
#         ]
#         self.assertEqual(expected_records, result_records)


# Switched to C++
# class TestBuildUser2Host(unittest.TestCase):
#     def test_small_data(self):
#         input_records = [
#             {
#                 'key': 'first-cid(TRASH)',
#                 'host': 'test-host.ru',
#                 'vector': du.array_tostring([1, 2, 3, 4, 5]),
#             },
#             {
#                 'key': 'first-cid(TRASH)',
#                 'host': 'another-host.ru',
#                 'vector': du.array_tostring([5, 6, 7, 8, 9]),
#             }
#         ]
#         reducer = clust_features.UserVectorReducer()
#         generator = RecordsGenerator([input_records])
#         result_records = list(reducer({'key': 'first-cid(TRASH)'}, generator))
#
#         first_record = result_records[0]
#         features = list(du.array_fromstring(first_record['features']))
#         expected_features = [6, 8, 10, 12, 14]
#         self.assertEqual(expected_features, features)
#
#         expected_records = [
#             {
#                 'key': 'first-cid(TRASH)',
#                 'features': '\x00\x00\xc0@\x00\x00\x00A\x00\x00 A\x00\x00@A\x00\x00`A'
#             }
#         ]
#         self.assertEqual(expected_records, result_records)


# TODO: Написать тесты для User2Clust
# Нужно или взаимодействовать с YT для получения get_cluster_centers_and_norms
# или сделать локальный кусок данных

# class BuildUser2Clust(usinttest.TestCase):
#     pass
