from yt.wrapper import ypath_join
from datacloud.config.yt import GREP_ROOT, AGGREGATES_FOLDER


CONTACT_LOG_DIR = ypath_join(GREP_ROOT, 'contact_actions/weekly')


class ContacActionsBuildConfig(object):

    def __init__(self, root=None, tag='CONTACT_ACTIONS', days_to_take=720, use_cloud_nodes=False,
                 min_retro=None, max_retro=None, is_retro=True,
                 snapshot_date=None, email_id_value_to_cid=None, phone_id_value_to_cid=None):
        self.days_to_take = days_to_take
        self.tag = tag
        self.use_cloud_nodes = use_cloud_nodes
        self.contact_log_dir = CONTACT_LOG_DIR
        self.is_retro = is_retro
        if self.is_retro:
            self.ext_id_key = 'external_id'
            self.root = root
            self.input_tables = [ypath_join(root, 'get_yuids/input')]
            self.data_dir = ypath_join(root, 'datacloud/aggregates/contact_actions')
            self.features_table_path = ypath_join(self.data_dir, 'features')
            self.min_retro = min_retro
            self.max_retro = max_retro
            assert self.min_retro and self.max_retro
        else:
            self.ext_id_key = 'cid'
            self.snapshot_date = snapshot_date
            self.input_tables = [email_id_value_to_cid, phone_id_value_to_cid]
            self.features_table_path = ypath_join(AGGREGATES_FOLDER, 'contact_actions', snapshot_date)
            self.min_retro = snapshot_date
            self.max_retro = snapshot_date
