# -*- coding: utf-8 -*-
from datacloud.features.contact_actions.contact_actions_grep import run_grep
from datacloud.features.contact_actions.build_config import CONTACT_LOG_DIR


def test_grep(yt_client, yql_client):
    date_from = date_to = '2020-01-01'
    run_grep(date_from, date_to, yql_client=yql_client, yt_client=yt_client, use_cloud_nodes=False)
    expected_result = [
        {
            'dwelltime': 516,
            'id_type': 'phone',
            'id_value': '79052131333',
            'id_value_md5': '0000bc1ed8fad2e58a2364b0b0746502',
            'parent_title': ('\xc3\x91\xc2\x81\xc3\x91\xc2\x8d\xc3\x90\xc2\xbd\xc3\x90'
                             '\xc2\xb4\xc3\x90\xc2\xb2\xc3\x90\xc2\xb8\xc3\x91\xc2\x87'
                             ' - \xc3\x90\xc2\x92\xc3\x90\xc2\xb0\xc3\x90\xc2\xba\xc3'
                             '\x90\xc2\xb0\xc3\x90\xc2\xbd\xc3\x91\xc2\x81\xc3\x90\xc2'
                             '\xb8\xc3\x90\xc2\xb8 \xc3\x90\xc2\xb2\xc3\x82\xc2\xa0\xc3'
                             '\x90\xc2\xa1\xc3\x90\xc2\xb0\xc3\x90\xc2\xbd\xc3\x90\xc2'
                             '\xba\xc3\x91\xc2\x82-\xc3\x90\xc2\x9f\xc3\x90\xc2\xb5\xc3'
                             '\x91\xc2\x82\xc3\x90\xc2\xb5\xc3\x91\xc2\x80\xc3\x90\xc2'
                             '\xb1\xc3\x91\xc2\x83\xc3\x91\xc2\x80\xc3\x90\xc2\xb3\xc3'
                             '\x90\xc2\xb5 - \xc3\x91\xc2\x81\xc3\x90\xc2\xb2\xc3\x90'
                             '\xc2\xb5\xc3\x90\xc2\xb6\xc3\x90\xc2\xb8\xc3\x90\xc2\xb5 '
                             '\xc3\x90\xc2\xbe\xc3\x90\xc2\xb1\xc3\x91\xc2\x8a\xc3\x91'
                             '\xc2\x8f\xc3\x90\xc2\xb2\xc3\x90\xc2\xbb\xc3\x90\xc2\xb5'
                             '\xc3\x90\xc2\xbd\xc3\x90\xc2\xb8\xc3\x91\xc2\x8f \xc3\x91'
                             '\xc2\x80\xc3\x90\xc2\xb0\xc3\x90\xc2\xb1\xc3\x90\xc2\xbe'
                             '\xc3\x91\xc2\x82\xc3\x90\xc2\xbe\xc3\x90\xc2\xb4\xc3\x90'
                             '\xc2\xb0\xc3\x91\xc2\x82\xc3\x90\xc2\xb5\xc3\x90\xc2\xbb'
                             '\xc3\x90\xc2\xb5\xc3\x90\xc2\xb9 \xc3\x90\xc2\xbd\xc3\x90'
                             '\xc2\xb0\xc3\x82\xc2\xa0Avito \xc3\xa2\xc2\x80\xc2\x94 '
                             '\xc3\x90\xc2\x9e\xc3\x90\xc2\xb1\xc3\x91\xc2\x8a\xc3\x91'
                             '\xc2\x8f\xc3\x90\xc2\xb2\xc3\x90\xc2\xbb\xc3\x90\xc2\xb5'
                             '\xc3\x90\xc2\xbd\xc3\x90\xc2\xb8\xc3\x91\xc2\x8f \xc3\x90'
                             '\xc2\xbd\xc3\x90\xc2\xb0\xc3\x82\xc2\xa0\xc3\x91\xc2\x81'
                             '\xc3\x90\xc2\xb0\xc3\x90\xc2\xb9\xc3\x91\xc2\x82\xc3\x90'
                             '\xc2\xb5 \xc3\x90\xc2\x90\xc3\x90\xc2\xb2\xc3\x90\xc2\xb8'
                             '\xc3\x91\xc2\x82\xc3\x90\xc2\xbe'),
            'parent_url': 'https://m.avito.ru/sankt-peterburg/vakansii/rabotnik_dlya_izgotovleniya_sendvichey_1839611552',
            'referer': '/sankt-peterburg/vakansii/rabotnik_dlya_izgotovleniya_sendvichey_1839611552',
            'title': ('\xc3\x90\xc2\x9f\xc3\x90\xc2\xbe\xc3\x90\xc2\xb7\xc3\x90\xc2\xb2'
                      '\xc3\x90\xc2\xbe\xc3\x90\xc2\xbd\xc3\x90\xc2\xb8\xc3\x91\xc2\x82'
                      '\xc3\x91\xc2\x8c'),
            'ts': 1579531066,
            'url': 'tel:+7 905 213-13-33',
            'yuid': '1'
        },
        {
            'dwelltime': 66,
            'id_type': 'phone',
            'id_value': '79006349302',
            'id_value_md5': '1b533b466e31630846d2624f2d001236',
            'parent_title': ('\xc3\x90\xc2\x92\xc3\x90\xc2\xb0\xc3\x90\xc2\xba\xc3\x90'
                             '\xc2\xb0\xc3\x90\xc2\xbd\xc3\x91\xc2\x81\xc3\x90\xc2\xb8'
                             '\xc3\x91\xc2\x8f \xc3\x90\xc2\x9a\xc3\x90\xc2\xbe\xc3\x90'
                             '\xc2\xbc\xc3\x90\xc2\xbf\xc3\x90\xc2\xbb\xc3\x90\xc2\xb5'
                             '\xc3\x90\xc2\xba\xc3\x91\xc2\x82\xc3\x90\xc2\xbe\xc3\x90'
                             '\xc2\xb2\xc3\x91\xc2\x89\xc3\x90\xc2\xb8\xc3\x90\xc2\xba '
                             '\xc3\x90\xc2\xb7\xc3\x90\xc2\xb0\xc3\x90\xc2\xba\xc3\x90'
                             '\xc2\xb0\xc3\x90\xc2\xb7\xc3\x90\xc2\xbe\xc3\x90\xc2\xb2 '
                             '\xc3\x90\xc2\xb2 \xc3\x90\xc2\xa1\xc3\x90\xc2\xb0\xc3\x90'
                             '\xc2\xbd\xc3\x90\xc2\xba\xc3\x91\xc2\x82-\xc3\x90\xc2\x9f'
                             '\xc3\x90\xc2\xb5\xc3\x91\xc2\x82\xc3\x90\xc2\xb5\xc3\x91'
                             '\xc2\x80\xc3\x90\xc2\xb1\xc3\x91\xc2\x83\xc3\x91\xc2\x80'
                             '\xc3\x90\xc2\xb3\xc3\x90\xc2\xb5, \xc3\x91\xc2\x80\xc3\x90'
                             '\xc2\xb0\xc3\x90\xc2\xb1\xc3\x90\xc2\xbe\xc3\x91\xc2\x82'
                             '\xc3\x90\xc2\xb0 \xc3\x90\xc2\xb2 \xc3\x90\xc2\xa0\xc3\x91'
                             '\xc2\x8b\xc3\x90\xc2\xb1\xc3\x90\xc2\xb0\xc3\x91\xc2\x86'
                             '\xc3\x90\xc2\xba\xc3\x90\xc2\xbe\xc3\x90\xc2\xb5 \xc3\x90'
                             '\xc2\x94\xc3\x90\xc2\xb5\xc3\x90\xc2\xbb\xc3\x90\xc2\xbe'),
            'parent_url': 'https://spb.hh.ru/vacancy/35105168',
            'referer': 'https://spb.hh.ru/vacancy/35105168',
            'title': '+7&nbsp;(900)&nbsp;6349302',
            'ts': 1579531587,
            'url': 'tel:+79006349302',
            'yuid': '1'
        }
    ]
    result = list(yt_client.read_table(CONTACT_LOG_DIR + '/' + date_to))
    assert result == expected_result
