# -*- coding: utf-8 -*-
import sys
from library.python.nyt import client as nyt_client
# nyt_client.initialize(sys.argv)
nyt_client.initialize(list(map(lambda it: it.encode(), sys.argv)))
import os
import numpy as np
from library.python import resource
import yt.wrapper as yt_wrapper
from datacloud.features.dssm import fast_dssm45


def get_query_vectors(for_cpp=True):
    """
    If vector is returned for python mapper it should be transposed.
    Remove this param after final switch to C++
    """
    query2vectors = []
    for line in resource.find('/query_vectors.txt').strip().split(b'\n'):
        parts = line.strip().split(b'#')
        query2vectors.append([float(i) for i in parts[2].split(b' ')])
    query2vectors = np.array(query2vectors)
    if not for_cpp:
        query2vectors = query2vectors.T
    return query2vectors


def run_dot_product(path_config, yt_client):
    yt_token = yt_wrapper.config['token'] or os.environ.get('YT_TOKEN')
    assert yt_token, '[DSSM DOT PRODUCT] No YT_TOKEN provided'
    query2vectors = get_query_vectors()
    fast_dssm45.fast_dot_product(
        yt_token,
        yt_client.config['proxy']['url'],
        query2vectors,
        str(path_config.vectors_table),
        str(path_config.dot_table)
    )
    yt_client.remove(path_config.vectors_table)
