# -*- coding: utf-8 -*-
import yt.wrapper as yt_wrapper
from datacloud.features.dssm import dssm_main
from datacloud.dev_utils.yt import yt_utils
from datacloud.config.yt import YT_PROXY


def log_step(idx):
    print('\n\n === step {} === \n\n'.format(idx))


TOKEN = ''  # robot_dc


def compute_prod_dssm():
    for date in ["2018-05-11", "2018-05-18"]:
        DAYS_TO_TAKE = 7
        TEST = False

        yt_client = yt_utils.get_yt_client(YT_PROXY)
        yt_client.config['token'] = TOKEN

        processor = dssm_main.DSSMTables(date, days_to_take=DAYS_TO_TAKE,
                                         test=TEST, yt_client=yt_client)

        log_step(1)
        with processor.yt_client.Transaction():
            processor.create_folders()
            processor.step_1_run_prepare_title_url()

        log_step(2)
        processor.step_2_dssm_step()

        log_step(3)
        processor.step_3_run_dot_product()

        log_step(4)
        processor.step_4_join_cids()

        log_step(5)
        processor.step_5_run_get_max_features()

        # log_step(6)
        # processor.step_6_run_join_scores()


if __name__ == '__main__':
    yt_wrapper.config.set_proxy(YT_PROXY)
    yt_wrapper.config['token'] = TOKEN

    compute_prod_dssm()
