#include <util/generic/string.h>

namespace Datacloud {
namespace Features {
namespace DSSM {

void FastDSSMStep5(
    const TString& ytToken,
    const TString& cluster,
    const TString& inputTable,
    const TString& outputTable);

void FastUniqueHashReduce(
    const TString& ytToken,
    const TString& cluster,
    const TString& inputTable,
    const TString& outputTable);

void FastJoinCidsReduce(
    const TString& ytToken,
    const TString& cluster,
    const TString& inputDotTable,
    const TString& inputHas2KeyTable,
    const TString& outputTable
);

void FastBynaryConverter(
    const TString& ytToken,
    const TString& cluster,
    const TString& inputTable,
    const TString& outputTable
);

void FastDotProduct(
    const TString& ytToken,
    const TString& cluster,
    const TVector<TVector<float> >& clusterCenters,
    const TString& inputTable,
    const TString& outputTable
);

}  // namespace Datacloud
}  // namespace Features
}  // namespace DSSM
