# -*- coding: utf-8 -*-
import sys
from library.python.nyt import client as nyt_client
# nyt_client.initialize(sys.argv)
nyt_client.initialize(list(map(lambda it: it.encode(), sys.argv)))
import os
import yt.wrapper as yt_wrapper
from datacloud.features.dssm import fast_dssm45


def join_cids(path_config, yt_client):
    yt_token = yt_wrapper.config['token'] or os.environ.get('YT_TOKEN')
    assert yt_token, '[DSSM JOIN CIDS] No YT_TOKEN provided'
    # with yt_client.Transaction():
    # TODO: Move sort and remove to C++ code and run under single transaction
    # TODO: Send cloud_nodes_spec to C++
    yt_client.run_sort(
        path_config.dot_table,
        sort_by=['hash'],
        spec=dict(
            title='[{}] dot_product sort'.format(path_config.tag),
            **path_config.cloud_nodes_spec
        )
    )
    fast_dssm45.fast_join_cids_reduce(
        yt_token,
        yt_client.config['proxy']['url'],
        str(path_config.dot_table),
        str(path_config.yuid2title_url4_table_all),
        str(path_config.id2_dot_tmp)
    )
    yt_client.remove(path_config.dot_table)
    yt_client.remove(path_config.yuid2title_url4_table_all)
