from util.generic.string cimport TString
from util.generic.vector cimport TVector


cdef extern from "datacloud/features/dssm/sample_app/retro_grep.h" namespace "Datacloud::Retro" nogil:
    void GetRetroLogs(
        const TString& ytToken, const TString& cluster, const TString& inputYuidTable,
        const TVector[TString]& inputLogTables, const TString& outputTable) nogil


cdef _get_retro_logs(
    const TString& ytToken, const TString& cluster,
    const TString& inputYuidTable, const TVector[TString]& inputLogTables,
    const TString& outputTable):
    with nogil:
        GetRetroLogs(ytToken, cluster, inputYuidTable, inputLogTables, outputTable)


def get_retro_logs(ytToken, cluster, inputYuidTable, inputLogTables, outputTable):
    _get_retro_logs(ytToken, cluster, inputYuidTable, inputLogTables, outputTable)
