# -*- coding: utf-8 -*-
# Dot product is moved to C++ test is not actual
import unittest
from datacloud.features.dssm import dot_product
from datacloud.dev_utils.testing.testing_utils import RecordsGenerator


class TestDotWithQueryVectors(unittest.TestCase):
    def test_small_record(self):
        query2vectors = dot_product.get_query_vectors()
        mapper = dot_product.DotWithQueryVectorsMapper(query2vectors)
        input_records = [
            {
                'hash': '214b3bc4c00a37060aafc845f980235f',
                'vector': """\x0bs\xdd\xba\xb0\xa5\x8b\xbc\xd3\x13\x1c\xbc\xa8\'\t<\xcf\x9b\x07=[k\xa6;\x92\xf2\x0e\xbd\nC6\xbc6\xab\xed;B\x8a\x90\xbc\xac\xf4\x00;,\xa3\xbd\xbb\xf9\x12\xc7;R\xa0H\xbc\x1a\xb7\x0e\xbdh\xbaH\xbd\x81j\x13\xbdMm!\xbb\xa5\xe6\xcb;r\xd2z\xbd+\x04\x16=\xa1\x97\xf5\xbc\xc8s >\x89+\xd2\xbdi\t\xa3<\xd3&\x15\xbd\x02`\x11=\x9b3,\xbd\x81P\xaa\xbc\x87\x10\xcd;h\xe0\x0e=\x08\xd9\x0f\xbc\xfaM5\xbd\xad\x95t<\xbfl\xad\xbb\xe4O\xab\xbcDe~<Y\xb7:\xb7\xde\xc16<I\xc8\x1e<\xc9S,\xbd+\xe9\x17\xbd\xeb|\x0c=4f\x9b\xbc\x93\xc3\x0e\xbd\x14s\xb6<\xd6\xf6\x05=fW\xb5\xbcE\xb0\x16=\xa3\xe3\x96\xbc&\xb7\x89\xbd\xc5xM;\xcf\xd3A\xbd\xccQ\r\xbc\x88\xa0(\xbc\xafu\xd2<( \xce;!(\xbe\xbb^3\x81\xbd\x89\xb9\xc9\xb9u\xdf\x05\xbd\xc9\xf3(\xbcH\xa3y<\x85\x03s<i\xf26=\xb0\n\xb1;\x1c.\x05\xbcf\x1c\\\xbc\xd7\x9a\xd6;0\xde\x01=k;\x96;\x93\x91\xce<\x90\x02\xa4\xbc?\xa5(\xbdI\x06\x8a\xbd\xf5\xa2\xd6<\xad\xb3\xe3;\xfc$\r=\xe7A\xeb\xbc\xe6\xbe\xf2;\xbb\xf2\xbd\xbb\x8d\x05]\xbd\x85\x8d9<\xea\xbe\xd5\xbc]\x1d\xa9;\xe9R><\x10\x83!=u\x8f\x88\xbcTh\xef\xbc|\x16&=@\t\x07:\x08\xba\x08\xbcq\x91\xaa=\x8e\xf6\xd7\xbc\xd1\xde\x80<\x13\xdb\xdd<\xd2j\xc6;\x12\xafv=\xa3\x8e\xa2\xba\x87\x99\xce:\xef\xdf\xa4;\xfdJ\xf2<\x00\x88\x00<\xaa\x88\x9a\xbcS\x83F<Z{\xaa<\xdd\xcb\x91\xba\xcd\xfb\xa0\xbc5x\x1a<M\xa1\xb0;:\x08%=\xce\xaa\xc4\xbcQ\xc8\x02\xbd},\x00\xbc\xaa\xa55<\xd4\xc7U=\xc9\x98\xc9\xbc\xfb\xd1\n\xbc"\x8e\xe2<\x04\xcb\n\xbd\x0f\xcd\x82\xbc\x81l,\xbd\x08+\x0c\xbd\xb2\xaf\x1b=\x02\x9ft=1\xfe\xe3\xbc$\x00\xe1<P\xc5\xde<\x94R:=\xe5\xd4\x00\xbd\xbe\xae\xa7;\xcd\xae\xe8\xbc;C\xf1<\xff]3<RmU\xbc/\xd93<\xcfZ\xed\xbb\xd9\xf75\xbc\xa3\xe5\x8d\xbcj\xc1\t\xbd\xf7\xf3\xd0\xbcA\xafC\xbd]\xd9\x81\xbd3\xcd\x98=\xf4>g\xbdI\xd3?<\xc4\xc9\x0b<]\xbaQ\xbd"\x10\xf8<\xf3\x04@\xbcM\xee?=\xbe\xca\xd2<]2\xfe\xbc\xb3[\x15\xbd\xbb\x14\x8c=_\xee-\xbc\x85\xd8\x9d<\xbat&\xbdZ!\x08=\xe7@\x84<JI\x1d=d\xf0g:\x18\xe09=sN\x96=\xb1\x8b\x83<-\xed\r\xbb\\\x9cl;!p\x0c\xbd\x13L\x0e?\xff\x0b\xef<\xd9Nx\xbb\'\xee\xc7<\xc5G5=\xf7\x1d\xe5\xbc\x02Sj\xbbeB\xf3<I2\x8b:DE\xec\xbb\x9e\xbe\x0f=\xf5\xeb\xa7\xbb\xec!\xab;\x19a\r=\xaebC\xbav\xe3;\xbd\x7f\xde3=V\x87\x83;GY\x90<\xac\'~\xbcI\xb2\xd5<\xe7`E;\xba\xb2\xc3;\xf9mq\xbc\xa3\xcd\xae<mg\x82\xbc}\x13m<S\x0f\x8e<\xef\x8f\x13\xbd\xf5\xd9\xba\xbcF\xa56\xbd;\x8a\x93<H_u;rk\xd4=>\xda\x80\xbb\x92\xe8\\\xbc\xef\xff.=\x95\xf0B\xbd33\x1b\xbd\xe3\xac\x0c\xbd\xba\x92Y\xbc\xb1B\xc4<\xf9\xc0\xdf<\xea\xd0\xff<\xc2\xf8\xe0<\xc7\xef\n:q\xf8\xa1>w\xc4\xdf<\xc5\x00\x9a<\x15\x83w=\x9f\xa4\x8a=\x87\xb3\x0e\xbcS\xd7\x1b\xbc\xe5\x01\x86\xbd\x1ai\xa1<Wf\xa6<\xe4n3=\x10\xcc\x10=\x15l\xfc\xbe\xef\xa6~<\xb7\x84\xcf\xbc\x02\xa3\xa9\xbc\xb01A\xbc\xca\xe7u\xbdh\n\x8e\xbcc\xd9\x0c=uWy\xbcJm\xd9\xbb\x1b=\xd8\xbc\xccm\x08\xbd\xc0M\x94=x\xa3\xf3<\xaa\xfe\xb6\xbc\xc8\xad\xaa\xba(\x8e\x15\xbd!\xc7W=\xb1W\xe9<q\x85\xc6<k\xdb\t=\xd9\x87\x95;\xc35\x16\xba)\xee\x1a=\xd5\xa1\xc8<\xf3\x01\xd5;\xe6-\x1c\xba>\xb0W:P\xd8\'\xbd\xe46\xde;\xac\x85\x1f={8\xce=\x011b\xbd\xdb\x84i<\xe3\xe9\xee;l\xbf\x8e<|\xce~\xbaM\x90\x80\xbd\xff\xca\xe6\xbc{\x95W\xbc\xba\x86\xec\xbc\x01\xfdu\xbb\xd7<\xe9\xbc\\\xf9\x93<H\xd7\x95<\xccH\x1f\xbb\x1b<\xee<N\xff\x91\xbdE\xe0\xc3\xbd\xb2\xd0>=\xc7\xb3\xbc;l\xb3\xb7\xbdp7j\xbd\x04WV\xbc{O\x1f\xbd\x01\xda\xb1\xbc\xd1\n\xd1\xbb\x8c\xb2P=\xc1t\\\xbd-\xba\xa4\xbdg\\[=p\xca|;\xf8?\xa9\xbc\t\xf1\x86\xbc\x9d\x05%<\xfe\x90\xae<Uz\x90\xbb8j\x8c\xbd?14<F\\\xd2<]\xf7\xcb\xbbw\xc3\x03\xba\xfe\xba\x19={_\xf6<"""  # noqa
            }
        ]
        generator = RecordsGenerator([input_records])
        # result_records = [mapper(input_records[0]).next()]
        result_records = list(mapper(generator))
        expected_records = [
            {
                'hash': '214b3bc4c00a37060aafc845f980235f',
                'dot_array': """\x07+\x93>\xab\x80\x82>\x1c\x0b\x94>\xce\xf8\x84>O\x00\xa3>\xf5\x82\x9b>/\xeb\x90>\xe7\x15\xb0>:V\x8e>\x8d2\x9f>\xa8X\x9d>\xc67\xaa>\xcd\xc5\x98>\x93\xa4\x8c>\xd6\xb8\x97>Yz\x99>q\xe1\xa4>\xd6t\x9d>\x11\x06\x90>%\x1a\x90>\x93\xfc\x83>F\xd1\x98>}\xf0\x90>\x1d\xb2\x9a>\xba\xf2\x85>]\x10\xa1>\xb0a\xa0>zt\x91>Y\x15\x8e>#\xe1\x9c>\xcc\xf4\xb6>h\xee\x87>]s\x80>z7\xa1>;o\x8f>\xeaj\x9b>\xb5\x06\xa2>\x19t\xa5>\xcf\xe6\xa8>\x173\x97>\x8c\xa9\xab>\n\xc8\xad>\xb75\xa5>9\xe1\xb0>\xc1`\x84>C\x12\x94>\x13}\xa0>\xc1%\xa4>#\xeb\xa6>O\xfe\xae>\x00\xdf\x88>\x93\x96\x88>\xed\x85\x96>T\x7f\x9f>\xfbJ\xa2>.\x1c\x9e>\xf0\xb1\x8f>\xb8W\x91>\xd3\x04\x9c>rP\x89>M\x19\xa2>\x11Y\x9f>\xb1A\xb8>\x1d\x1b\xac>C\x80\x9c>\xab\xb6\x93>\x97\xcd\xa3>\xed~\xbb>\xd7+\xaa>\xf1^\x98>\xc2j\xb2>\xb5+\x80>\xbdB\x9d>\xb2\x01\xa4>\xeb\xb7\x98>\xdfO\x95>\xe6\xa8\x94>\x15\xa3\x96>\x9e\xbc\x9c>\xe4\xae\xa3>\xeb8\xaa>\\\xa6\xa7>\x93\xb4\x97>\x862\x8c>C\xb6\x91>S*\xa2>u\x06\xa6>\xd8J\xad>\xf5\xfe\xa1>\xa6q\x96>9\x1f\x94>H\xc5\xa0>\xb3}\x93>\xe4\x92\x95>n\xb6\xb6>\xc1\'|>\x11\xff~>Be\x8e>\xc0k\x8d>\x92\xa3\xa2>u\xe3\x8b>BW\x9c>\xed\x19\x93>m\xe6\xa3>\xd8A\xa7>+*\x8d>Yn\xb2>\xb6V\x9d>\xfd\xe1\xb2>\xcb\x9a\x8d>r\xe1\xa6>\xae\xfd\x9c>vl\x82>\x92O\x8d>;\xe3\x96>\x1b\xbf\x96>\xac&|>Tp\xa6>\xff\x11\x8e>\xea\x9f\x8c>]\x14\x9a>=\x86\x9d>R\x81\xaa>\xa3j\xa2>\x073\x9c>\xee\xdf\x91>Rm\xa3>G\x13\x90>E\xbf\x9d>F\x14\x9c>4G\x91>\xc7\xb6\x8d>\xacP\xc0>6\x14\xae>-0\xa9>\xc7\x1b\x93>\x10d\xad>\xb8g\x90>\xdb\x06\x9e>\x989\xa5>p9\x8d>\xdd(\x99>\xc4\x9c\xa7>\x8a\xafr>\x9f\xc2\x9f>\xb7\x0c\x92>\xe7m\x9d>\xcb\xbf\x9a>=S\x9e>\x06\x0e\x86>\xf5v\xaf>{\xd4\xac>\xa8L\xaa>\x15L\x97>\x97f\x8e>\xe8\xdb\x93>\xae\xc8\x90>Pe\xa0>h\xb9\xa0>\xd9\x87\xad>Q\xff\xad>\xd5E\xb5>\xbb\xda\x95>\xfa\x96\x95>\x14_\xa8>\x89\xe3\x9f>q\xc6\xa9>\x7f\xfc\x86>\xe5\x88\x95>|W\x94>\x0f\xb2\x9f>\xcd\x8f\x8f>\xe6\xf1\x96>J\xd9\xc2>^q\x94>\xcdX\x90>\xb7~\xab>\xef\xe7\x9d>e\x9aN>\xb2\xe7\x86>\xa7\xdb\xa3>\xe6\x9b\x8e>0G\x9c>q\xb3\x92>\x87@\x8e>&7\x9b>\xeat\x8c>\xff\t\xb2>=:\xa4>\xe0\x0e\x94>\xf4I\x89>c\xd6\x9a>\x0e{\x9a>-{\xac>j8\xae>\xcd\xcf\x85>\x83\xa7\x81>\xab\x1a\x96>\x97\x99\x9e>\xd8\xec\x9c>\xe8G\x9f>#I\x8d>\xd2P\x94>\xf9\xb9\xa7>\x9c\xdc\x86>\xc1\xed\x91>\xd2.\x98>\x84x\x9c>KI\x9a>\x11\xd9\xa4>[\xe4\x88>f(\x88>\xadX\x9b>z\xaa\x80>p\x94\x94>E\xd7\x9b>M]\x9e>\x93\xb1\x80>J\xe2\x98>{l\xaa>\xb4\xcf\x93>y\x89\xa2>\xb2\x12\xa5>\x1e\xf5\x9b>\x93i\x98>\x7f\x06\x86>\xb8\xdf\xaa>\xb3#\x99>8O\x9b>\x03\x92\x86>\xfe\xba\xab>\x96\xcd\xa9>T>\x94>rE\x95>\xdfC\x95>{U\x9f>?j\x94>V~\x94>\xc1m\x9b>\xdf\xf4\x9b>5\xb1\x98>\xcd\xf2\x96>\xa2\xbf\xa1>\xd4\xda\x99>\x9f\xa8p>\xe3\xf7\xb3>\xcd~\xab>Zv\x9f>\xca\x82\xaf>TJ\xb4>t4\x96>\xa1\xa0\x9d>\x90\xa1\x89>\xbf\xcf\x8f>\x1b+\x91>\xb23\x8b>\xf1e\xb6>f`\x8d>aT\x9a>\x0c[\xac>"\xd2\x88>\x89\xca\x9a>\xd8O\x9b>\x1e\x0b\xae>4w\xa5>\x88\x1f\x84>\xa8\xd9\x95>\x00Un>)\x87\x8e>\x92\xf9\x98>\xf0\x1f\x9d>\x12\x03\x8f>k\n\x92>\xc6\xc3\xa8>\xc4\xd7\xa0>\xf41\x97>\xd0\xac\x9e>\x03\x0f\xac>\x85\x06\x92>\x04\xe5\x92>I\xea\x89>g5\x9a>\xfcD\x9a>\x89\xb1\xa1>\x89\xeb\x98>T\xef\x9a>\x15\x02\x85>\x96\xd9\x98>\xc6\xdb\xa5>\x956\x86>\x10r\x86>4Z\x90>\xcb\xef\x8d>7\x8f\xab>\x8e\xd8\x99>\xe8\xa0\x9d>\xe0 \x82>P\xac\x9a>\xa6]\xa7> \xdc\x8c>]\xf9\xab>\x14\xff\x90>6\x93\x89>k\xaf\xa3>T\xf4\xa5>\xa0\xea\x94>\xb6\xa4\x91>c\xdd\x86>\x9f\xe3\x85>9\xc0\xa2>\x14\xb3\x81>\xd1O\xad>)I\xa0>\xe0\xcb\x93>,\x07\x96>^\xb6\xa7>\xffs\x8f>C-\x9e>\xe1r\x84>3\x9a\x98>\xd2\xa3\xa3>U\xea\x8e>S|\x8f>\xde\x99\x91>\x10l\xb0>\xd35\x92>\xd0\x1c\x9c>\x0e\x05\x8f>\x1d~\xa5>X\xac\x95>[2\x92>O\x18\x9a>\xa0\xb1\xa2>$\xa3\xa6>\xd7\\\x9b>\x16*\x8b>t\xc9\xa2>\xf4\x8d\x92>j\xc8\x94>\xc3\xae\xb5>\xa6\xfd\x94>F\xa2\xa3>\x07\xc9\x95>\x12\xd0\xa3>}\xa7\xaa>hI\x95>B\x05\x93>\xc7\xd2\xb1>\x81V\xb6>\x16\xf5\xab>\xfe,\x92>\x7f{\x93>\xa8\xee\x8a>\\\xc2\xa8>%\xb6\xa0>\xc8\xcb\xa0>\xf2\x1c\x8c>\x04\xf2b>fu\x87>\n:\xa5>B\xca\xa2>0\n^>\xde\xb7\x92>\x06\xdf\x88>v~\xab>-\xa8\x9a>kf\x93>\x84\x9c\x9f>\x80\xb9\x94>\x15\xdd\x90>\xa2\x97\xaa>\x0b\t\xa6>\x02w\x8f>y\x1c\x8a>rL\x88>\x89"\x89>\x13\x99\xa7>z{\x9a>r\xe4\x9a>\xf5n\x99>z\x8d\xaa>G\xa5\x8e>I\xf4\xa8>\xc3\xe8\x80>H\x05\xb0>\x02t\x98>h0\x98>\xe1i\x9e>\x13\xf0\xaa>=!\x82>\x95=\x91>\xae\x9c\x98>cU\xa7>J-\xa4>:\xe9\xb7>X\xbb\xa5>\xca\x0bx>\xed\xd6\x91>\ne\x9d>\x9fI\x83>"""}  # noqa

        ]
        self.assertEqual(expected_records, result_records)


class TestConvertToBinary(unittest.TestCase):
    def test_small_record(self):
        input_records = [
            {'hash': '123', 'vector': '1 2 3 4 5'}
        ]
        result_records = [dot_product.convert_to_binary(input_records[0]).next()]
        expected_records = [
            {'hash': '123', 'vector': '\x00\x00\x80?\x00\x00\x00@\x00\x00@@\x00\x00\x80@\x00\x00\xa0@'}
        ]
        self.assertEqual(expected_records, result_records)

    def test_real_record(self):
        input_records = [
            {
                'hash': '214b3bc4c00a37060aafc845f980235f',
                'vector': '-0.00168952474 -0.0170467794 -0.00952621084 0.00837127119 0.033107575 0.00507871574 -0.0348993018 -0.0111243818 0.00725307595 -0.0176440515 0.00196770858 -0.00578727387 0.00607525976 -0.0122452546 -0.034842588 -0.0490058959 -0.0359902419 -0.00246317987 0.00622256333 -0.0612358525 0.0366250686 -0.0299795289 0.15669167 -0.102622099 0.019901948 -0.0364139788 0.0354919508 -0.0420414023 -0.0207903404 0.00625807373 0.0348819792 -0.00877977163 -0.0442638174 0.0149282636 -0.00529250456 -0.0209121183 0.0155270733 -1.11291529e-05 0.01115462 0.00969130639 -0.0420720913 -0.0370876007 0.0342988186 -0.0189696327 -0.0348544829 0.0222716704 0.0327061042 -0.0221364014 0.0367891975 -0.0184190925 -0.0672438592 0.00313525018 -0.047321137 -0.00862545893 -0.0102921799 0.0256908815 0.00629045442 -0.00580312358 -0.0630862564 -0.00038475942 -0.0326838084 -0.0103120292 0.0152366832 0.0148323821 0.0446647741 0.00540288538 -0.00812866911 -0.0134345051 0.00654922007 0.0317060351 0.00458471989 0.0252158996 -0.0200207531 -0.041173216 -0.0673948005 0.0262007508 0.00694890926 0.0344590992 -0.0287179481 0.00740801077 -0.00579675799 -0.0539603718 0.0113252448 -0.0260920115 0.00516097108 0.011616447 0.0394316316 -0.0166699681 -0.0292245522 0.0405487865 0.000515121967 -0.00834513456 0.08328522 -0.0263626836 0.0157312471 0.0270820018 0.00605521444 0.0602255538 -0.00124021282 0.00157623074 0.00503157778 0.0295767728 0.00784492493 -0.0188639946 0.0121162711 0.0208107717 -0.00111233781 -0.019651318 0.00942807365 0.0053903223 0.0402910486 -0.0240072273 -0.0319293179 -0.00782310683 0.0110868607 0.0521925241 -0.0246089865 -0.00847291481 0.0276556648 -0.033885017 -0.0159669202 -0.0420956649 -0.0342207253 0.038009353 0.0597219542 -0.0278311688 0.0274658874 0.0271936953 0.0454889089 -0.031453032 0.00511726644 -0.028403664 0.0294510033 0.0109477034 -0.0130265523 0.0109770736 -0.00724349124 -0.0111064548 -0.0173214134 -0.0336317196 -0.0255069565 -0.047774557 -0.0634028688 0.0746101364 -0.0564565212 0.0117080892 0.00853199139 -0.0512031205 0.0302811302 -0.01171993 0.0468581207 0.0257314406 -0.0310298745 -0.0364644043 0.0683989152 -0.0106159141 0.0192682836 -0.0406386629 0.0332349315 0.0161442291 0.038399972 0.000884777168 0.0453797281 0.0733918175 0.016057821 -0.00216562604 0.00361039396 -0.034286622 0.5558483 0.0291805249 -0.00378887937 0.0244055521 0.0442578979 -0.0279683899 -0.00357550429 0.0296947453 0.00106198445 -0.00721040554 0.0350938961 -0.00512456382 0.00522254966 0.0345164277 -0.000745336409 -0.0458712205 0.0439133607 0.00401393604 0.0176206958 -0.0155123882 0.0260859895 0.00301175728 0.0059722336 -0.0147356922 0.0213382896 -0.0159184579 0.0144699784 0.0173412915 -0.0360259376 -0.0228090081 -0.0445912108 0.0180102494 0.00374408253 0.103720561 -0.0039322665 -0.0134831835 0.042724546 -0.0475927182 -0.0378906243 -0.0343445651 -0.0132796112 0.0239575822 0.0273136962 0.0312275477 0.027462367 0.000530001184 0.316348583 0.0273153614 0.0187991951 0.0604277439 0.0676968023 -0.00870979484 -0.00951178651 -0.065433301 0.0197034366 0.0203124713 0.0438069254 0.0353508592 -0.4930121 0.0155427298 -0.0253318381 -0.020707611 -0.0117916316 -0.0600355044 -0.0173389465 0.0343870036 -0.0152186053 -0.00663534272 -0.0263963249 -0.0333078355 0.0724139214 0.0297410339 -0.0223382302 -0.00130217616 -0.0365125239 0.0526801385 0.0284841973 0.0242335517 0.0336565189 0.00456331344 -0.000573005702 0.0378247835 0.02449123 0.00650047651 -0.000595776713 0.000822786125 -0.0409777761 0.00678144582 0.0389458388 0.100693665 -0.055222515 0.0142528666 0.00729106506 0.0174252614 -0.000972009962 -0.0627752319 -0.028172968 -0.0131581975 -0.0288728364 -0.00375348353 -0.0284713935 0.0180632398 0.0182911307 -0.00243048649 0.0290813949 -0.0712877363 -0.0956426039 0.0465857461 0.00575873582 -0.0896976888 -0.0571817756 -0.0130822696 -0.0388941579 -0.0217103977 -0.00637946324 0.0509515256 -0.0538222827 -0.0804332271 0.0535549186 0.00385728106 -0.0206603855 -0.0164723564 0.0100721391 0.021309372 -0.00440911436 -0.0685619712 0.0109980693 0.025678765 -0.00622455636 -0.000502637995 0.0375318453 0.0300748255'  # noqa
            }
        ]
        result_records = [dot_product.convert_to_binary(input_records[0]).next()]
        expected_records = [
            {
                'hash': '214b3bc4c00a37060aafc845f980235f',
                # this line breaks highlight
                'vector': """\x0bs\xdd\xba\xb0\xa5\x8b\xbc\xd3\x13\x1c\xbc\xa8\'\t<\xcf\x9b\x07=[k\xa6;\x92\xf2\x0e\xbd\nC6\xbc6\xab\xed;B\x8a\x90\xbc\xac\xf4\x00;,\xa3\xbd\xbb\xf9\x12\xc7;R\xa0H\xbc\x1a\xb7\x0e\xbdh\xbaH\xbd\x81j\x13\xbdMm!\xbb\xa5\xe6\xcb;r\xd2z\xbd+\x04\x16=\xa1\x97\xf5\xbc\xc8s >\x89+\xd2\xbdi\t\xa3<\xd3&\x15\xbd\x02`\x11=\x9b3,\xbd\x81P\xaa\xbc\x87\x10\xcd;h\xe0\x0e=\x08\xd9\x0f\xbc\xfaM5\xbd\xad\x95t<\xbfl\xad\xbb\xe4O\xab\xbcDe~<Y\xb7:\xb7\xde\xc16<I\xc8\x1e<\xc9S,\xbd+\xe9\x17\xbd\xeb|\x0c=4f\x9b\xbc\x93\xc3\x0e\xbd\x14s\xb6<\xd6\xf6\x05=fW\xb5\xbcE\xb0\x16=\xa3\xe3\x96\xbc&\xb7\x89\xbd\xc5xM;\xcf\xd3A\xbd\xccQ\r\xbc\x88\xa0(\xbc\xafu\xd2<( \xce;!(\xbe\xbb^3\x81\xbd\x89\xb9\xc9\xb9u\xdf\x05\xbd\xc9\xf3(\xbcH\xa3y<\x85\x03s<i\xf26=\xb0\n\xb1;\x1c.\x05\xbcf\x1c\\\xbc\xd7\x9a\xd6;0\xde\x01=k;\x96;\x93\x91\xce<\x90\x02\xa4\xbc?\xa5(\xbdI\x06\x8a\xbd\xf5\xa2\xd6<\xad\xb3\xe3;\xfc$\r=\xe7A\xeb\xbc\xe6\xbe\xf2;\xbb\xf2\xbd\xbb\x8d\x05]\xbd\x85\x8d9<\xea\xbe\xd5\xbc]\x1d\xa9;\xe9R><\x10\x83!=u\x8f\x88\xbcTh\xef\xbc|\x16&=@\t\x07:\x08\xba\x08\xbcq\x91\xaa=\x8e\xf6\xd7\xbc\xd1\xde\x80<\x13\xdb\xdd<\xd2j\xc6;\x12\xafv=\xa3\x8e\xa2\xba\x87\x99\xce:\xef\xdf\xa4;\xfdJ\xf2<\x00\x88\x00<\xaa\x88\x9a\xbcS\x83F<Z{\xaa<\xdd\xcb\x91\xba\xcd\xfb\xa0\xbc5x\x1a<M\xa1\xb0;:\x08%=\xce\xaa\xc4\xbcQ\xc8\x02\xbd},\x00\xbc\xaa\xa55<\xd4\xc7U=\xc9\x98\xc9\xbc\xfb\xd1\n\xbc"\x8e\xe2<\x04\xcb\n\xbd\x0f\xcd\x82\xbc\x81l,\xbd\x08+\x0c\xbd\xb2\xaf\x1b=\x02\x9ft=1\xfe\xe3\xbc$\x00\xe1<P\xc5\xde<\x94R:=\xe5\xd4\x00\xbd\xbe\xae\xa7;\xcd\xae\xe8\xbc;C\xf1<\xff]3<RmU\xbc/\xd93<\xcfZ\xed\xbb\xd9\xf75\xbc\xa3\xe5\x8d\xbcj\xc1\t\xbd\xf7\xf3\xd0\xbcA\xafC\xbd]\xd9\x81\xbd3\xcd\x98=\xf4>g\xbdI\xd3?<\xc4\xc9\x0b<]\xbaQ\xbd"\x10\xf8<\xf3\x04@\xbcM\xee?=\xbe\xca\xd2<]2\xfe\xbc\xb3[\x15\xbd\xbb\x14\x8c=_\xee-\xbc\x85\xd8\x9d<\xbat&\xbdZ!\x08=\xe7@\x84<JI\x1d=d\xf0g:\x18\xe09=sN\x96=\xb1\x8b\x83<-\xed\r\xbb\\\x9cl;!p\x0c\xbd\x13L\x0e?\xff\x0b\xef<\xd9Nx\xbb\'\xee\xc7<\xc5G5=\xf7\x1d\xe5\xbc\x02Sj\xbbeB\xf3<I2\x8b:DE\xec\xbb\x9e\xbe\x0f=\xf5\xeb\xa7\xbb\xec!\xab;\x19a\r=\xaebC\xbav\xe3;\xbd\x7f\xde3=V\x87\x83;GY\x90<\xac\'~\xbcI\xb2\xd5<\xe7`E;\xba\xb2\xc3;\xf9mq\xbc\xa3\xcd\xae<mg\x82\xbc}\x13m<S\x0f\x8e<\xef\x8f\x13\xbd\xf5\xd9\xba\xbcF\xa56\xbd;\x8a\x93<H_u;rk\xd4=>\xda\x80\xbb\x92\xe8\\\xbc\xef\xff.=\x95\xf0B\xbd33\x1b\xbd\xe3\xac\x0c\xbd\xba\x92Y\xbc\xb1B\xc4<\xf9\xc0\xdf<\xea\xd0\xff<\xc2\xf8\xe0<\xc7\xef\n:q\xf8\xa1>w\xc4\xdf<\xc5\x00\x9a<\x15\x83w=\x9f\xa4\x8a=\x87\xb3\x0e\xbcS\xd7\x1b\xbc\xe5\x01\x86\xbd\x1ai\xa1<Wf\xa6<\xe4n3=\x10\xcc\x10=\x15l\xfc\xbe\xef\xa6~<\xb7\x84\xcf\xbc\x02\xa3\xa9\xbc\xb01A\xbc\xca\xe7u\xbdh\n\x8e\xbcc\xd9\x0c=uWy\xbcJm\xd9\xbb\x1b=\xd8\xbc\xccm\x08\xbd\xc0M\x94=x\xa3\xf3<\xaa\xfe\xb6\xbc\xc8\xad\xaa\xba(\x8e\x15\xbd!\xc7W=\xb1W\xe9<q\x85\xc6<k\xdb\t=\xd9\x87\x95;\xc35\x16\xba)\xee\x1a=\xd5\xa1\xc8<\xf3\x01\xd5;\xe6-\x1c\xba>\xb0W:P\xd8\'\xbd\xe46\xde;\xac\x85\x1f={8\xce=\x011b\xbd\xdb\x84i<\xe3\xe9\xee;l\xbf\x8e<|\xce~\xbaM\x90\x80\xbd\xff\xca\xe6\xbc{\x95W\xbc\xba\x86\xec\xbc\x01\xfdu\xbb\xd7<\xe9\xbc\\\xf9\x93<H\xd7\x95<\xccH\x1f\xbb\x1b<\xee<N\xff\x91\xbdE\xe0\xc3\xbd\xb2\xd0>=\xc7\xb3\xbc;l\xb3\xb7\xbdp7j\xbd\x04WV\xbc{O\x1f\xbd\x01\xda\xb1\xbc\xd1\n\xd1\xbb\x8c\xb2P=\xc1t\\\xbd-\xba\xa4\xbdg\\[=p\xca|;\xf8?\xa9\xbc\t\xf1\x86\xbc\x9d\x05%<\xfe\x90\xae<Uz\x90\xbb8j\x8c\xbd?14<F\\\xd2<]\xf7\xcb\xbbw\xc3\x03\xba\xfe\xba\x19={_\xf6<"""  # noqa
            }
        ]
        self.assertEqual(expected_records, result_records)


if __name__ == '__main__':
    unittest.main()
