# -*- coding: utf-8 -*-
import unittest
from datacloud.features.dssm import join_cids
from datacloud.dev_utils.testing.testing_utils import FakeContext, RecordsGenerator


# TODO: Create C++ tests based on this
class TestTitleUrlReducer(unittest.TestCase):
    def test_small_data(self):
        input_dot_records = [
            {
                'hash': 'hash-one',
                'dot_array': 'dot-array-one'
            }
        ]
        ext_id_records = [
            {
                'hash': 'hash-one',
                'key': '111'
            },
            {
                'hash': 'hash-one',
                'key': '222'
            }
        ]
        context = FakeContext()
        reducer = join_cids.JoinReduce()
        generator = RecordsGenerator([input_dot_records, ext_id_records], context)
        result_records = list(reducer({'hash': '0000000d2f68f15f5119f8ce58ba6ac1'}, generator, context))
        expected_records = [
            {
                'key': '111',
                'features': 'dot-array-one'
            },
            {
                'key': '222',
                'features': 'dot-array-one'
            }
        ]
        self.assertEqual(expected_records, result_records)

    def test_real_data(self):
        input_dot_records = [
            {
                'hash': '0000000d2f68f15f5119f8ce58ba6ac1',
                'dot_array': '\xfc\x9b\xd0>\xb3\xb2\xa5>\x12\xb6\xbd>b\x82\xaa>-\xdc\xb3>\xc9\xd8\x9e>\xdb\x9a\xae>]*\xb3>fW\x94>\x10\xe9\xb5>\xb4\xa6\xa1>{4\xaa>z4\x9a>"\n\xb7>\xf3"\xbe>\xa7o\xbf>`\xad\xa4>hG\xae>es\xb3>7\xb2\x9d>\r\xaa\x8d>\xa9\xa3\xaf>\xbf\x93\xad>mo\xbb>\xc7r\x9a>)I\xa1>\x87n\xcd>\xd2R\xa1>\xa6$\x92>\x88M\x9a>\x0c\x08\xb8>\x9f\'\xad>-\xe1\xa3>\x9f\t\x9c>e\xa8\xa5>\xa1\xef\xb8>\xb6\xca\xbb>\xd4\x8c\xbe>+t\xb2>I\x1c\x9e>Y\xcc\xb8>7\x16\x97>\x027\xb1>\xb3\xfd\xbb>v\x80\xa7>H\xec\xaf>kT\xa9>\x9d\xf9\x9f>S9\xad>\xb3\xd2\xb5>\x80\x1c\xad>7\xa7\xb2>\xcf\xf7\xa8>\xa6\x88\xb0>\x08^\xb8>\x16\xdd\xaa>\x9ez\x9f>\xa4\xbe\xb5>\xfe{\xa9>h\x88\x9a>\xf8\x9d\xb4>\xf0\xfa\xb8>\xef\xce\xbc>\xfb\xf0\xc9>\xe9\x06\x92>a\xa3\xa2>]V\xb4>\x9b1\xb1>\x0e\xf0\xb6>\x11\xcf\xa2>\x1fb\xa4>Ea\x97>\x9f\xbd\xb6>\xc75\x9f>P\x03\xab>\x1bM\xa6>h\x92\xb2>1R\x88>\xda\x1c\xb8>\xfe\xf0\x94>h\x14\xb4>s\xc3\xac>\xb7\xdb\xa9>\x81O\xa4>\x0c{\xb4>\xff|\xb1>\xb0\xd7\xb5>\xf7\x8b\xa9>E\x1a\xaf>gY\xab>\xdf\x8a\xa1>$\xd6\xba>p\xa9\xb6>_\x80\xa1>\xf1\xc9\xad>\xcfc\xa4>\xda\xcd\x85>"j\x98>\xc0Y\xb1>-1\xa1>c\x99\x99>~\x80\x98>Ht\xa7>hJ\xa5>\x99u\xa8>\x1cD\xb5>\xcd\xfd\xad>\x08\x03\xa6>\x07\x9b\xb9>\xf7E\x94>\xa2\x0f\xb3>X\xd6\xbc>\xc3\xdf\xab>l\x9f\xaf>\xa9\xcb\xa7>\x14\x13\xae>=:\xb5>\xc8\xb9\x99>\xae\xff\xa0>#<\xb4>)\x1e\xbd>%}\xbb>h1\xb9>]U\xa7>\x06\x9f\xac>Z\x93\xa1>\x89t\xb9>\xf2\xbd\xad>\xf5b\xb6>i\xf9\xa3>\x05\x96\xb1>\xc7}\xa3>\xee!\xa9>s\x8b\xbe>\xce\xce\xab>\x88Y\xb7>\xa6@\xa9>\x8f\xf2\xa5>k\xb6\xa0>\xb2:\xc8>\xb0\x9a\x9e>\x0b\x1a\x9a>\xf0\xa5\xa2>\xf2\xb3\x99>\x17\xa1\xa6>\xa2\xaf\xad>\x16{\xa9>\x82\x04\xb0>0\xec\xae>\x9f\x9c\xa9>\x12D\xb1>\xbb\x88\xae>\xd9\xd0\x9d> \xc9\xb2>:\xea\xa1>\xd1\t\x9c>\x99\xb0\x96>$\xce\xae>\xfc\xc5\xab>b\xf8\xa4>%\xe2\xaf>\x8d\x18\xbc>F\xc2\x98>\xf2\x9e\xb7>\xe7\xdf\xbc>\x85\xb9\xb5>?:\xa2>\xe6\xf8\xa7>\xe9z\xab>zy\x96>\xc1\xa7\xb4>\r\x99\x9f>\xa6\xd0\xa3>q\xd5\xb2>\xb9\x13\x95>\xfc8\xab>;z\xa3>\x81\xcc\xa7>\x9a\x89\x8e>\x8f\xc5\xb6>\xfb\x8a\x93>\x95q\xa1>\xb9\xc0\xb4>\x12"\xaf>$?\xaf>\x06\x93\xc8>\xd2\xff\xad>\x82\xfa\xa8>\x98\xa3\xa7>\xc9\xa4\xb3>\xe0\xc7\xb0>\xe0N\xb3>\x8fQ\xa6>8a\xa9>\xe1\r\xa3>B\xf6\x86>\x021\xa0>\xcfX\xa9>\x1bh\xa0>\x96^\xa9>!(\xc7>\xd5\xd0\x9b>\xf4\xeb\x9d>de\x9f>\xa7\xda\xa9>9\x94\x99>>F\xa5>\x8cU\x9b>\xb9\xe0\xa1>5r\xaa>\xc6\xf2\xa3>Xh\xb6>\xa3\xbd\xad>\xf5\x03\x9a>\x00n\xa4>\xdc\xa7\xae>U\xcf\xb4>a\xc4\xbb>\xe8\x8a\xb1>\x05\x89\xad>\x83\xbc\xaf>\xa9!\xbf>\xf7\x9c\xa1>O\n\xb2>\xb2\xf4\xb4>]\xc4\x9c>\x85\xe9\xbb>\x9eV\xb7>\xef\xb4\xa3>\xe3\x92\xa7>7e\x93>Z0\x9e>\xb1?\x98>\xb3\xa5\xb0>\x88\'\xb3>\x8a\x99\xa7>\xc5Y\xb4>\x8a\xcc\xab>\x03f\xae>e\x0c\x9d>+\xa8\xa6>:c\x99>%\xef\xa9>\xcb\x96\x8b>\x0fo\x97>\xe7\xc8\xaf>\xdb\x02\xbb>\xa75\x9c>\xea$\xb0>F2\xab>\xd8\xfb\xb3>\xcb\xac\xb5>:\xd2\x92>\xd0t\x97>D\xb7\xab>\xc6\t\x9f>\x99\x96\xb1>w:\xa7>\xc5\x97\xaa>\x7fP\xc2>`\x83\xaa>\xb0\xba\x97>\x1bu\xa2>\xe1\xf1\x9f>A\xde\xb4>\x19\x90\x96>\xfc\xe9\xad>;\x8e\xa7>\xdbI\xa0>s\xf1\xc4>l\x17\xa5>I\xb3\xae>\xfa\xd5\xb2>Y[\x92>Ed\xa2>\\Q\x99>\x80\xd9\xb0>B\x11\x9c>%\xcb\xae>\xca\x86\xa3>\x9b\xc6\xac>\x1c\xae\xa0>\x00\x8e\xb8>\x17!\x99>\x9b\xd6\xa8>"\x8a\x9a>T\xe3\xab>`T\xa3>`Q\x97>\x10\x02\xb4>\x91}\x8b>\x15\xc2\x9c>M\xaa\xb4>#\x1b\xab>_\xa9\xa4>\x84\x85\xa5>X\x92\x94>\xa6\x03\xad>\n\x18\xbe>\x1a\xca\xa1>\x0f\x0e\xad>\x14\x01\x97>G\xd0\xbe>\x14\t\xae>\xa8\xba\xb4>\x82;\xac>\xa2\x07\xab>\x98l\xa8>(\x8e\xb6>\x05\xcb\xb3>\x06\xc2\x90>?#\xb0>\xfbA\xb7>@v\xb4>\xc6C\xa5>\xf5\xfa\xaf>x\xf0\xaf>\x92\x8a\xaa>#\x7f\xa2>2\x1e\x9c>\xb9\x8d\xbd>,0\xac>\xbb|\x88>\xd6C\xb9>`\x98\xa3>t\x8e\xb0>\xd7\x1c\xa9>$\x8f\xb0>u\x90\xa9>6\xb7\x92>\xe6\xb3\x9b>\xe6D\xad>\xf8t\xb4>\xcb\xe0\xa6>\xc8\xf0\xbb>\x0b\x89\x8a>\x0cr\x9a>\xa7\x0f\xab>\x9b\xf6\xb2>\x07\xcd\xa3>\x0eU\x9c>\xb5\xa3\xb9>\xe0l\xa3>A\xa1\xb5>\xf5\xbe\xb5><+\xb4>\xba\x88\xa9>\x89\x16\xc3>do\xa2>\xad\xcf\xa3>\xda^\xb7>\xacq\xa8>\xeb;\xb3>u\xf3\xb0>\t\x97\xb1>e\xf8\xb0>\xc5\x0f\x97>\xb5y\xb2>\x06\x88\xb8>\x1b\xa1\xa5>g\xe5\xaf>\xa8\xf5\x8f>\t\x12\xb4>\x8f\xfd\x96>M\xaa\xb3>\x87\x9f\xb6>-X\xbc>\xc5\xf8\xae>#\x86\x92>\xd5\xb1\x8c>\x80\x89\xbe>dN\xb7>\x00i\x9f>\x06l\x99>\x80\xe9\xa4>\x9d\x93\xa9>\x80\xf9\xa6>\xafh\xa2>9D\x9c>\x1eN\xb9>\xb2\xc2\xb7>\x7f\xed\x99>\xd7\x87\xbb>\xc6\xa8\x8a>\xa6\xad\xb4>-\xe3\x99>\xbc\x93\xbc>\x1f\xfb\x94>.\xfd\xa7>\xf48\x99>tU\xa3>S\x91\x9e>/V\xae>\xef$\xa6>\xe6\xd8\xa3>\xda\xa0\xc3>HC\x9f>\x10\xb0\x9e>\x94\xdf\x9f>\xdfa\xa3>'  # noqa
            }
        ]
        ext_id_records = [
            {
                'hash': '0000000d2f68f15f5119f8ce58ba6ac1',
                'key': '111'
            },
            {
                'hash': '0000000d2f68f15f5119f8ce58ba6ac1',
                'key': '222'
            }
        ]
        context = FakeContext()
        reducer = join_cids.JoinReduce()
        generator = RecordsGenerator([input_dot_records, ext_id_records], context)
        result_records = list(reducer({'hash': '0000000d2f68f15f5119f8ce58ba6ac1'}, generator, context))
        expected_records = [
            {
                'key': '111',
                'features': '\xfc\x9b\xd0>\xb3\xb2\xa5>\x12\xb6\xbd>b\x82\xaa>-\xdc\xb3>\xc9\xd8\x9e>\xdb\x9a\xae>]*\xb3>fW\x94>\x10\xe9\xb5>\xb4\xa6\xa1>{4\xaa>z4\x9a>"\n\xb7>\xf3"\xbe>\xa7o\xbf>`\xad\xa4>hG\xae>es\xb3>7\xb2\x9d>\r\xaa\x8d>\xa9\xa3\xaf>\xbf\x93\xad>mo\xbb>\xc7r\x9a>)I\xa1>\x87n\xcd>\xd2R\xa1>\xa6$\x92>\x88M\x9a>\x0c\x08\xb8>\x9f\'\xad>-\xe1\xa3>\x9f\t\x9c>e\xa8\xa5>\xa1\xef\xb8>\xb6\xca\xbb>\xd4\x8c\xbe>+t\xb2>I\x1c\x9e>Y\xcc\xb8>7\x16\x97>\x027\xb1>\xb3\xfd\xbb>v\x80\xa7>H\xec\xaf>kT\xa9>\x9d\xf9\x9f>S9\xad>\xb3\xd2\xb5>\x80\x1c\xad>7\xa7\xb2>\xcf\xf7\xa8>\xa6\x88\xb0>\x08^\xb8>\x16\xdd\xaa>\x9ez\x9f>\xa4\xbe\xb5>\xfe{\xa9>h\x88\x9a>\xf8\x9d\xb4>\xf0\xfa\xb8>\xef\xce\xbc>\xfb\xf0\xc9>\xe9\x06\x92>a\xa3\xa2>]V\xb4>\x9b1\xb1>\x0e\xf0\xb6>\x11\xcf\xa2>\x1fb\xa4>Ea\x97>\x9f\xbd\xb6>\xc75\x9f>P\x03\xab>\x1bM\xa6>h\x92\xb2>1R\x88>\xda\x1c\xb8>\xfe\xf0\x94>h\x14\xb4>s\xc3\xac>\xb7\xdb\xa9>\x81O\xa4>\x0c{\xb4>\xff|\xb1>\xb0\xd7\xb5>\xf7\x8b\xa9>E\x1a\xaf>gY\xab>\xdf\x8a\xa1>$\xd6\xba>p\xa9\xb6>_\x80\xa1>\xf1\xc9\xad>\xcfc\xa4>\xda\xcd\x85>"j\x98>\xc0Y\xb1>-1\xa1>c\x99\x99>~\x80\x98>Ht\xa7>hJ\xa5>\x99u\xa8>\x1cD\xb5>\xcd\xfd\xad>\x08\x03\xa6>\x07\x9b\xb9>\xf7E\x94>\xa2\x0f\xb3>X\xd6\xbc>\xc3\xdf\xab>l\x9f\xaf>\xa9\xcb\xa7>\x14\x13\xae>=:\xb5>\xc8\xb9\x99>\xae\xff\xa0>#<\xb4>)\x1e\xbd>%}\xbb>h1\xb9>]U\xa7>\x06\x9f\xac>Z\x93\xa1>\x89t\xb9>\xf2\xbd\xad>\xf5b\xb6>i\xf9\xa3>\x05\x96\xb1>\xc7}\xa3>\xee!\xa9>s\x8b\xbe>\xce\xce\xab>\x88Y\xb7>\xa6@\xa9>\x8f\xf2\xa5>k\xb6\xa0>\xb2:\xc8>\xb0\x9a\x9e>\x0b\x1a\x9a>\xf0\xa5\xa2>\xf2\xb3\x99>\x17\xa1\xa6>\xa2\xaf\xad>\x16{\xa9>\x82\x04\xb0>0\xec\xae>\x9f\x9c\xa9>\x12D\xb1>\xbb\x88\xae>\xd9\xd0\x9d> \xc9\xb2>:\xea\xa1>\xd1\t\x9c>\x99\xb0\x96>$\xce\xae>\xfc\xc5\xab>b\xf8\xa4>%\xe2\xaf>\x8d\x18\xbc>F\xc2\x98>\xf2\x9e\xb7>\xe7\xdf\xbc>\x85\xb9\xb5>?:\xa2>\xe6\xf8\xa7>\xe9z\xab>zy\x96>\xc1\xa7\xb4>\r\x99\x9f>\xa6\xd0\xa3>q\xd5\xb2>\xb9\x13\x95>\xfc8\xab>;z\xa3>\x81\xcc\xa7>\x9a\x89\x8e>\x8f\xc5\xb6>\xfb\x8a\x93>\x95q\xa1>\xb9\xc0\xb4>\x12"\xaf>$?\xaf>\x06\x93\xc8>\xd2\xff\xad>\x82\xfa\xa8>\x98\xa3\xa7>\xc9\xa4\xb3>\xe0\xc7\xb0>\xe0N\xb3>\x8fQ\xa6>8a\xa9>\xe1\r\xa3>B\xf6\x86>\x021\xa0>\xcfX\xa9>\x1bh\xa0>\x96^\xa9>!(\xc7>\xd5\xd0\x9b>\xf4\xeb\x9d>de\x9f>\xa7\xda\xa9>9\x94\x99>>F\xa5>\x8cU\x9b>\xb9\xe0\xa1>5r\xaa>\xc6\xf2\xa3>Xh\xb6>\xa3\xbd\xad>\xf5\x03\x9a>\x00n\xa4>\xdc\xa7\xae>U\xcf\xb4>a\xc4\xbb>\xe8\x8a\xb1>\x05\x89\xad>\x83\xbc\xaf>\xa9!\xbf>\xf7\x9c\xa1>O\n\xb2>\xb2\xf4\xb4>]\xc4\x9c>\x85\xe9\xbb>\x9eV\xb7>\xef\xb4\xa3>\xe3\x92\xa7>7e\x93>Z0\x9e>\xb1?\x98>\xb3\xa5\xb0>\x88\'\xb3>\x8a\x99\xa7>\xc5Y\xb4>\x8a\xcc\xab>\x03f\xae>e\x0c\x9d>+\xa8\xa6>:c\x99>%\xef\xa9>\xcb\x96\x8b>\x0fo\x97>\xe7\xc8\xaf>\xdb\x02\xbb>\xa75\x9c>\xea$\xb0>F2\xab>\xd8\xfb\xb3>\xcb\xac\xb5>:\xd2\x92>\xd0t\x97>D\xb7\xab>\xc6\t\x9f>\x99\x96\xb1>w:\xa7>\xc5\x97\xaa>\x7fP\xc2>`\x83\xaa>\xb0\xba\x97>\x1bu\xa2>\xe1\xf1\x9f>A\xde\xb4>\x19\x90\x96>\xfc\xe9\xad>;\x8e\xa7>\xdbI\xa0>s\xf1\xc4>l\x17\xa5>I\xb3\xae>\xfa\xd5\xb2>Y[\x92>Ed\xa2>\\Q\x99>\x80\xd9\xb0>B\x11\x9c>%\xcb\xae>\xca\x86\xa3>\x9b\xc6\xac>\x1c\xae\xa0>\x00\x8e\xb8>\x17!\x99>\x9b\xd6\xa8>"\x8a\x9a>T\xe3\xab>`T\xa3>`Q\x97>\x10\x02\xb4>\x91}\x8b>\x15\xc2\x9c>M\xaa\xb4>#\x1b\xab>_\xa9\xa4>\x84\x85\xa5>X\x92\x94>\xa6\x03\xad>\n\x18\xbe>\x1a\xca\xa1>\x0f\x0e\xad>\x14\x01\x97>G\xd0\xbe>\x14\t\xae>\xa8\xba\xb4>\x82;\xac>\xa2\x07\xab>\x98l\xa8>(\x8e\xb6>\x05\xcb\xb3>\x06\xc2\x90>?#\xb0>\xfbA\xb7>@v\xb4>\xc6C\xa5>\xf5\xfa\xaf>x\xf0\xaf>\x92\x8a\xaa>#\x7f\xa2>2\x1e\x9c>\xb9\x8d\xbd>,0\xac>\xbb|\x88>\xd6C\xb9>`\x98\xa3>t\x8e\xb0>\xd7\x1c\xa9>$\x8f\xb0>u\x90\xa9>6\xb7\x92>\xe6\xb3\x9b>\xe6D\xad>\xf8t\xb4>\xcb\xe0\xa6>\xc8\xf0\xbb>\x0b\x89\x8a>\x0cr\x9a>\xa7\x0f\xab>\x9b\xf6\xb2>\x07\xcd\xa3>\x0eU\x9c>\xb5\xa3\xb9>\xe0l\xa3>A\xa1\xb5>\xf5\xbe\xb5><+\xb4>\xba\x88\xa9>\x89\x16\xc3>do\xa2>\xad\xcf\xa3>\xda^\xb7>\xacq\xa8>\xeb;\xb3>u\xf3\xb0>\t\x97\xb1>e\xf8\xb0>\xc5\x0f\x97>\xb5y\xb2>\x06\x88\xb8>\x1b\xa1\xa5>g\xe5\xaf>\xa8\xf5\x8f>\t\x12\xb4>\x8f\xfd\x96>M\xaa\xb3>\x87\x9f\xb6>-X\xbc>\xc5\xf8\xae>#\x86\x92>\xd5\xb1\x8c>\x80\x89\xbe>dN\xb7>\x00i\x9f>\x06l\x99>\x80\xe9\xa4>\x9d\x93\xa9>\x80\xf9\xa6>\xafh\xa2>9D\x9c>\x1eN\xb9>\xb2\xc2\xb7>\x7f\xed\x99>\xd7\x87\xbb>\xc6\xa8\x8a>\xa6\xad\xb4>-\xe3\x99>\xbc\x93\xbc>\x1f\xfb\x94>.\xfd\xa7>\xf48\x99>tU\xa3>S\x91\x9e>/V\xae>\xef$\xa6>\xe6\xd8\xa3>\xda\xa0\xc3>HC\x9f>\x10\xb0\x9e>\x94\xdf\x9f>\xdfa\xa3>'  # noqa
            },
            {
                'key': '222',
                'features': '\xfc\x9b\xd0>\xb3\xb2\xa5>\x12\xb6\xbd>b\x82\xaa>-\xdc\xb3>\xc9\xd8\x9e>\xdb\x9a\xae>]*\xb3>fW\x94>\x10\xe9\xb5>\xb4\xa6\xa1>{4\xaa>z4\x9a>"\n\xb7>\xf3"\xbe>\xa7o\xbf>`\xad\xa4>hG\xae>es\xb3>7\xb2\x9d>\r\xaa\x8d>\xa9\xa3\xaf>\xbf\x93\xad>mo\xbb>\xc7r\x9a>)I\xa1>\x87n\xcd>\xd2R\xa1>\xa6$\x92>\x88M\x9a>\x0c\x08\xb8>\x9f\'\xad>-\xe1\xa3>\x9f\t\x9c>e\xa8\xa5>\xa1\xef\xb8>\xb6\xca\xbb>\xd4\x8c\xbe>+t\xb2>I\x1c\x9e>Y\xcc\xb8>7\x16\x97>\x027\xb1>\xb3\xfd\xbb>v\x80\xa7>H\xec\xaf>kT\xa9>\x9d\xf9\x9f>S9\xad>\xb3\xd2\xb5>\x80\x1c\xad>7\xa7\xb2>\xcf\xf7\xa8>\xa6\x88\xb0>\x08^\xb8>\x16\xdd\xaa>\x9ez\x9f>\xa4\xbe\xb5>\xfe{\xa9>h\x88\x9a>\xf8\x9d\xb4>\xf0\xfa\xb8>\xef\xce\xbc>\xfb\xf0\xc9>\xe9\x06\x92>a\xa3\xa2>]V\xb4>\x9b1\xb1>\x0e\xf0\xb6>\x11\xcf\xa2>\x1fb\xa4>Ea\x97>\x9f\xbd\xb6>\xc75\x9f>P\x03\xab>\x1bM\xa6>h\x92\xb2>1R\x88>\xda\x1c\xb8>\xfe\xf0\x94>h\x14\xb4>s\xc3\xac>\xb7\xdb\xa9>\x81O\xa4>\x0c{\xb4>\xff|\xb1>\xb0\xd7\xb5>\xf7\x8b\xa9>E\x1a\xaf>gY\xab>\xdf\x8a\xa1>$\xd6\xba>p\xa9\xb6>_\x80\xa1>\xf1\xc9\xad>\xcfc\xa4>\xda\xcd\x85>"j\x98>\xc0Y\xb1>-1\xa1>c\x99\x99>~\x80\x98>Ht\xa7>hJ\xa5>\x99u\xa8>\x1cD\xb5>\xcd\xfd\xad>\x08\x03\xa6>\x07\x9b\xb9>\xf7E\x94>\xa2\x0f\xb3>X\xd6\xbc>\xc3\xdf\xab>l\x9f\xaf>\xa9\xcb\xa7>\x14\x13\xae>=:\xb5>\xc8\xb9\x99>\xae\xff\xa0>#<\xb4>)\x1e\xbd>%}\xbb>h1\xb9>]U\xa7>\x06\x9f\xac>Z\x93\xa1>\x89t\xb9>\xf2\xbd\xad>\xf5b\xb6>i\xf9\xa3>\x05\x96\xb1>\xc7}\xa3>\xee!\xa9>s\x8b\xbe>\xce\xce\xab>\x88Y\xb7>\xa6@\xa9>\x8f\xf2\xa5>k\xb6\xa0>\xb2:\xc8>\xb0\x9a\x9e>\x0b\x1a\x9a>\xf0\xa5\xa2>\xf2\xb3\x99>\x17\xa1\xa6>\xa2\xaf\xad>\x16{\xa9>\x82\x04\xb0>0\xec\xae>\x9f\x9c\xa9>\x12D\xb1>\xbb\x88\xae>\xd9\xd0\x9d> \xc9\xb2>:\xea\xa1>\xd1\t\x9c>\x99\xb0\x96>$\xce\xae>\xfc\xc5\xab>b\xf8\xa4>%\xe2\xaf>\x8d\x18\xbc>F\xc2\x98>\xf2\x9e\xb7>\xe7\xdf\xbc>\x85\xb9\xb5>?:\xa2>\xe6\xf8\xa7>\xe9z\xab>zy\x96>\xc1\xa7\xb4>\r\x99\x9f>\xa6\xd0\xa3>q\xd5\xb2>\xb9\x13\x95>\xfc8\xab>;z\xa3>\x81\xcc\xa7>\x9a\x89\x8e>\x8f\xc5\xb6>\xfb\x8a\x93>\x95q\xa1>\xb9\xc0\xb4>\x12"\xaf>$?\xaf>\x06\x93\xc8>\xd2\xff\xad>\x82\xfa\xa8>\x98\xa3\xa7>\xc9\xa4\xb3>\xe0\xc7\xb0>\xe0N\xb3>\x8fQ\xa6>8a\xa9>\xe1\r\xa3>B\xf6\x86>\x021\xa0>\xcfX\xa9>\x1bh\xa0>\x96^\xa9>!(\xc7>\xd5\xd0\x9b>\xf4\xeb\x9d>de\x9f>\xa7\xda\xa9>9\x94\x99>>F\xa5>\x8cU\x9b>\xb9\xe0\xa1>5r\xaa>\xc6\xf2\xa3>Xh\xb6>\xa3\xbd\xad>\xf5\x03\x9a>\x00n\xa4>\xdc\xa7\xae>U\xcf\xb4>a\xc4\xbb>\xe8\x8a\xb1>\x05\x89\xad>\x83\xbc\xaf>\xa9!\xbf>\xf7\x9c\xa1>O\n\xb2>\xb2\xf4\xb4>]\xc4\x9c>\x85\xe9\xbb>\x9eV\xb7>\xef\xb4\xa3>\xe3\x92\xa7>7e\x93>Z0\x9e>\xb1?\x98>\xb3\xa5\xb0>\x88\'\xb3>\x8a\x99\xa7>\xc5Y\xb4>\x8a\xcc\xab>\x03f\xae>e\x0c\x9d>+\xa8\xa6>:c\x99>%\xef\xa9>\xcb\x96\x8b>\x0fo\x97>\xe7\xc8\xaf>\xdb\x02\xbb>\xa75\x9c>\xea$\xb0>F2\xab>\xd8\xfb\xb3>\xcb\xac\xb5>:\xd2\x92>\xd0t\x97>D\xb7\xab>\xc6\t\x9f>\x99\x96\xb1>w:\xa7>\xc5\x97\xaa>\x7fP\xc2>`\x83\xaa>\xb0\xba\x97>\x1bu\xa2>\xe1\xf1\x9f>A\xde\xb4>\x19\x90\x96>\xfc\xe9\xad>;\x8e\xa7>\xdbI\xa0>s\xf1\xc4>l\x17\xa5>I\xb3\xae>\xfa\xd5\xb2>Y[\x92>Ed\xa2>\\Q\x99>\x80\xd9\xb0>B\x11\x9c>%\xcb\xae>\xca\x86\xa3>\x9b\xc6\xac>\x1c\xae\xa0>\x00\x8e\xb8>\x17!\x99>\x9b\xd6\xa8>"\x8a\x9a>T\xe3\xab>`T\xa3>`Q\x97>\x10\x02\xb4>\x91}\x8b>\x15\xc2\x9c>M\xaa\xb4>#\x1b\xab>_\xa9\xa4>\x84\x85\xa5>X\x92\x94>\xa6\x03\xad>\n\x18\xbe>\x1a\xca\xa1>\x0f\x0e\xad>\x14\x01\x97>G\xd0\xbe>\x14\t\xae>\xa8\xba\xb4>\x82;\xac>\xa2\x07\xab>\x98l\xa8>(\x8e\xb6>\x05\xcb\xb3>\x06\xc2\x90>?#\xb0>\xfbA\xb7>@v\xb4>\xc6C\xa5>\xf5\xfa\xaf>x\xf0\xaf>\x92\x8a\xaa>#\x7f\xa2>2\x1e\x9c>\xb9\x8d\xbd>,0\xac>\xbb|\x88>\xd6C\xb9>`\x98\xa3>t\x8e\xb0>\xd7\x1c\xa9>$\x8f\xb0>u\x90\xa9>6\xb7\x92>\xe6\xb3\x9b>\xe6D\xad>\xf8t\xb4>\xcb\xe0\xa6>\xc8\xf0\xbb>\x0b\x89\x8a>\x0cr\x9a>\xa7\x0f\xab>\x9b\xf6\xb2>\x07\xcd\xa3>\x0eU\x9c>\xb5\xa3\xb9>\xe0l\xa3>A\xa1\xb5>\xf5\xbe\xb5><+\xb4>\xba\x88\xa9>\x89\x16\xc3>do\xa2>\xad\xcf\xa3>\xda^\xb7>\xacq\xa8>\xeb;\xb3>u\xf3\xb0>\t\x97\xb1>e\xf8\xb0>\xc5\x0f\x97>\xb5y\xb2>\x06\x88\xb8>\x1b\xa1\xa5>g\xe5\xaf>\xa8\xf5\x8f>\t\x12\xb4>\x8f\xfd\x96>M\xaa\xb3>\x87\x9f\xb6>-X\xbc>\xc5\xf8\xae>#\x86\x92>\xd5\xb1\x8c>\x80\x89\xbe>dN\xb7>\x00i\x9f>\x06l\x99>\x80\xe9\xa4>\x9d\x93\xa9>\x80\xf9\xa6>\xafh\xa2>9D\x9c>\x1eN\xb9>\xb2\xc2\xb7>\x7f\xed\x99>\xd7\x87\xbb>\xc6\xa8\x8a>\xa6\xad\xb4>-\xe3\x99>\xbc\x93\xbc>\x1f\xfb\x94>.\xfd\xa7>\xf48\x99>tU\xa3>S\x91\x9e>/V\xae>\xef$\xa6>\xe6\xd8\xa3>\xda\xa0\xc3>HC\x9f>\x10\xb0\x9e>\x94\xdf\x9f>\xdfa\xa3>'  # noqa
            }
        ]
        self.assertEqual(expected_records, result_records)


if __name__ == '__main__':
    unittest.main()
