# -*- coding: utf-8 -*-
import unittest
from datacloud.features.dssm import join_scores
from datacloud.dev_utils.data import data_utils as du
from datacloud.dev_utils.testing.testing_utils import RecordsGenerator


class TestMaxReducer(unittest.TestCase):
    def test_small(self):
        input_records = [
            {
                'external_id': '111',
                'features': du.array_tostring([1, 2, 3, 4, 5])
            },
            {
                'external_id': '111',
                'features': du.array_tostring([5, 4, 3, 2, 1])
            },
            {
                'external_id': '111',
                'features': du.array_tostring([1, 1, 9, 1, 1])
            }

        ]
        reducer = join_scores.MaxFeatureReducer(ext_id_key='external_id')
        generator = RecordsGenerator([input_records])
        result_records = list(reducer({'external_id': '111'}, generator))
        features = list(du.array_fromstring(result_records[0]['features']))
        expected_features = [5, 4, 9, 4, 5]
        self.assertEqual(features, expected_features)

    def test_real(self):
        input_records = [
            {
                'external_id': '111',
                'features': b'g\xa5\x88>\x14-\x96>SR\x92>\xb1\xf7\x81>r%\x80>\x1f\xcbe>\xa0d\x96>\xc3t\x8f>V\xc5J>Vp\x85>U\'F>na\xa2>\x1dSM>n\\\x96>:i\x90>\x181\x80>\xa1&\x8c>\xae\xa3\x87>K\xb6\x95>B\xc7z>(\x8a\x8a>\xe1\xdf\x83>V\xa6\x80>\xd8\xd5z>7)[>\x80\xeb\x8c>\x0e\xd3\x95>\x9f\xa3\x92>\xc9\x9di>\xa0\xd6\x07>\\\x01\xaf>3\xfe\x92>\xc2\x83\x81>\x006b>)n\x90>\xdb\xc2\x83>\r\xe4\x90>\xb8\x95\xaa>\xb3\xba\x81>\x1d\xc8\x95>\x0b\xa6i>\x02\xc8\x80>4\xf4\xa4>\xbe\xc7\x88>\x08\xeeS>\x96*\x8c>\x87\x1d\x99>&%j>Mb\x8b>\t\xb3\x9d>[E\x9b>\xe5\xbe\x89>-\x15x>\t\xd0\x81>\xfa\xc9\x88>\xebb\x86>\xe0\xb3w>\xe6\x10\x8d>~\xff9>#\xf5\x11>\x85^\x8b>\xaf\xe3\x90>\xb6m\x90>l%\xa2>\x16J:>}\x1a\xa5>\xec\xb9h>kAh>\xf7\xc9\xa6>\xe9\x08\x87>-?_>\xab\x1c\\>\xd0(\x8a>\xc9.\x8b>\x81\xf0\x96>\x0eA\x9e>\xaa\xedP>&\xfa|>Fu\x8c>\xcf\x02\x80>\xf4\x7f{>.\x9a\x98>N\xf8p>_\x91\x8a>X\xf0n>\x8f\xe4\xab>\xe9\xb2\x94>\xdc\x8d\x86>l\xc4\x8d>hI\x9d>\xd7\x82\xb0>\xaa\x9f\xa8>\xbf\xa4\x7f>}\x90\x95>_r\x8c>\xbb\x9bk>\xd8\xd1a>\x927Q>\xef\x90\xa6>\x87\xdf\x87>R\x9aw>\x7f[P>M\xa5c>\xb5Kl>\xbd}\x91>K\xe7\x9b>d\x18\x94>>B\x9c>9\x80\x86>[O\x90>r\xc4^>\xc5\xd3\xa8>\xd57\x91>\x8e\xc9k>\x96\x9b\xbb>=Xn>\xa5I\x8c>z\x0b.>wE~>k&\x87>\x1d.x>\x8a\xd7\xa4>\xee\x98\x93>-P\x9f>\xab\xd6\x8a>)\xa9y>\xad\x7f\x92>\xf7T\x94>8\xb6\x92>\xcc4\x82>\xf4W\x95>H\xf7{>\xefJu>\x8f6\xa1>{h\x9c>\xce.\x91>\xde\xa1u>\r\xdcu>\xd6\x9c\x8d>\xe9\x1e\x9c>\x0f\xd8\x80>;\xc0l>\xc4\x91\x86>\x12\xb2b>\xe8\xf2\x8b>\xc2$8>\xe8R\x9c>\xb5O\x8a>ix\x8c>\xc5\xa1\x97>\x9d\xd3\x90>\xa0\x86\xa2>l\x9a\xa3>\x19\xaf\xd3>/\xe9r>+s,>k\xb9\x82>"\x8c\x8f>%\x9c\x9e>(TG>\xc8&\x88>\xf6\xe7\x88>X\xca\x86>\xaaq\x9e>a\x0c\x8f>D\x86M>A$S>u)y>%R\x84>\xb5\xefl>;\x84\x91>:\xd2\x84>\xed\xb6g>\xf4?\xa7>7\x16J>\x109h>\xc1\x13\x90>;Pq>\xec\xe6O>/\xa7j>K\xf7j>\xb34J>s\xf7\x82>K\xf6\x9f>\x1e\xe6\x8f>\xdc\x08\x97>\xe14\xb7>\xd0\xe6\x80>\xa2=\x8f>~\xf2\x93>C\xffk>\xd9\x90|>\x99\x0c\xb0>0\xee\x86>d\x8ad>\xd6u9>\xb6Z}>Gv\x8e>"\xfc\x85>\xdbjn>\xfd\x1a\x98>\xf0\x99`>1g}>\x06*h>b\xcb{>K\x8b=>\x90Aj>\xaf\xc7v>\xf5\xd1\x82>\xd7_\x9a>p+F>\xcf\xa8\x9d>\xcc"u>:*X>N\x81\x97>\xa4\xb8\x8b>\xc7\xeb}>^j`>\x1d\x16\xa8>\xec[\x85>\x06\x06M>\x10$\x99>\xcf\x97\x9b>\xd8\x9c:>\xcc\xe0\x98>Z6{>\xcb\xd0\x9e>\xb4XS>,an>-\xb7\x83>m\xfcM>,\xb9}>:\xff8>2\xa5\x92>#\xcb]>\x9dv\x8d>,\xcc\x9e>NW\x9e>\xc2FV>L^X>\x82\xfe\x10>\x9a\xf7G>\x8a\xa9\x81>\xdd\x8c@>\xed\x14^>\x80\x9cf>\xbc\xb6\xa9>\xb0^`>\xd7i\xa3>\x9aW\x95>\x8d{\x8a>@\x9a\x8b>\xae9\x87>&\x11\x89>\x00\xd2\x84>\xfc%\x8d>X;\x83>\xb0\x0c\x8d>d\xdax>\x1eH\xa8>\xf3\xc4\xb5>\xaf\xbd\x86>\x06\xe5\x87>\x88\x9c\x88>,\x00\xb2>J\x1a\x96>b\xff\x85>\xd3\xdc\x8f>\x96?\x84> J\x9d>U\xf0\x9b>\x80@p>\xa4(\xa7>\x08\xa2a>\xce\x02w>\x9a|\x85>\xf0\x7f\x8a>G\xd5\x94>\x13\xd2\x8e>\xd1\x80\x19>SXs>U\xdbf>5\x80\x8d>+\x15\x8e>\x0eQ\x98>v\xfb\x7f>\x0ce\x8d>~\xbd\x8b>*VY>\\\x12i>\xf3l0>\x02\x80m>\xcf\x02\x92>E\xe1j>\xe9\xac\x82>\xc2\xaeu>\x10E}>*\x80\x95>=\xaf\x88>9\xc5\x86>}b\xa5>\xd8yt>\xa1h\x98>\x91\xb9x>\xd3\xf7\xb5>\x9b\x7f\x93>\xe7\x0bz>-\x05<>\x84F\x91>\x9b=Q>\x9bkA>\xf7\x05\x7f>S\x8c8>3\\\xa5>pW\x85>\xe4\xfb.>R\x98\x83>\x03m\x96>\\Z8>\xb9\x9aD>r@\xae>\n#\x90>\xddF\x02>`\xa7\x8e>\xd3\x1e\x90>\xf3\x90i>\xa0\x94\x88>\x9b\n\x82>\r"">\x7f1O>9|\x9a>9S\x92>yXu>\x04\xfct>-\x9d9>\xe0\xb6\x8c>\x0b\xbeR>$\xd1Z>\xca~\xa8>\xab\xec\x80>1\x8aY>\xab\xf7j>7*\x8e>+\x05\x90>U\xaa\xa1>?2\x94>\xa2\x02\x96>H\x88\xa0>4\xb8~>g\x11\x80>\x89\x0c\x8c>\x10;\x9e>Zv\x9c>\x8a\xda\x95>\xd1\xc4X>\xd9S\xb6>>\x9c\x9b>\xd2\xa5u>\xcazN>\xe35\x9a>\xea\x13\x88>(\xb3`>0\xbb\\>\xbf\x19\x8d>\xac\xc9}>\x98\xeb\x9b>\xe5\xee\x87>\x19\xd0\x8b>\x93\xda\x80>\xbd#8>F\xa2\x99>B\xbd\x8b>\x97{[>;\xefX>}\x94s>\x84d\'>\xbbk\x9b>\x07\xe3x>\x84\xfb1>\xa5\n\xb4>;\x85\xa1>\xd6\xbf\x8c>\xc7_\x97>aro>\xabb\x8e>\xfa\xaf&>KsR>\x9c\xdb:>\x81\x12\x80>\xc9\xd7\x8c>\xb82\x89>\x19c\xbb>4\xbb\x80>?\xb7\x9d>;fq>\x04=\x7f>\xd3\xf1o>\x8b\xdb\xa3>\xe5\x0fu>\r\xd4\x86>'  # noqa
            },
            {
                'external_id': '111',
                'features': b'k\xc1q>Z\x8e\xa9>s\xe7k>Yhs>n\x87\xaa>\x83\nF>\xc7\xd7\x8e>x\x11\x9a>Vpy> \xbd\x9e>\xe3\xa3\x80>#\xdf\xa1>?M\x98>\xf2\x17i>\x1e\xec\x8e>\xe8\x8e\x88>\xd5\xeez>\xef\x8d\x92>3\x9f\x9a>n{\xa9>\xf6\x06R>\xa5\xd1\x84>\x08:y>\x93$\x87>\xd9&v>3d\xa8>Q\x1b\x90>:\xa2\x80>\x91V\x8b>\x8d\xaeP>\'\xee\xa4>\xa4\x00\x88>.\xe6z>.Q\x95>\xdb)\x87>\xd0\x96\xa2>\xe3\xdd\x9a>\x9d\x8b\xa2>\xd0\x0c\x81>=\x86\x99>\xa2@}>\xe4ql>"\x13\x90>\xbbo\xa8>\xc9\xd0\x84>\xbc]\xb9>\xa8\xc2\x89>I\xb3\x92>!\xbc\x9c>\x051\x98>`\xbe\x89>X\xf5\x7f>2z\x89>\xaf]\x87>\xc7\xef\xa1>\x90\xe9q>\xe1\x9aX>\xc6y\xaf>\xd8\xf8\x80>EZr>\x7fS\x85>2\x15x>(w\x9f>X|\x98>\x1a\xe0\x8f>\xd1\xe7\x98>G"\x81>x\t\x9d>!N\xba>{\x1c\x9a>X\x15\x8f>\xbe\x91p>\xc0\xfaz>]@\x8d><k\xab>\xd6r\xa5>y\x96l>\x98\xd7l>0\xd3{>\xb3\xeb\x96>\x8cY\x8a>\xf1h\xb3>-\xcf\x84>0\xbb\x94>5\xde\x82>\x95:\x84>-\xaf\x94>1\xb4\x92>J\xd1\x8b>N\xac\x8d>M\xda\xa1>J\x81\x9d>\xf7 }>#\x17R>\xa2\x0cv>\xf2\xeac>b\xe3:>!\x12\x8e>\xa1\x95u>\x13\x10\xaa>c\x85\x81>\x1c\xb4w>\xaa\xc7\\>\xe6\xef\x94>3E\xa2>\xcd9\x95>3\x82\xb1>\x14\x0b\x92>\\\xb7c>\x13\xbbe>\xeaI\xaa>\x17\xa1\x98>\xbel\x87>\np\x82>\t\n\x8c>1\x8av>\x99\x95x>X4\x97>\xc5\n\x8b>\xc0hE>\xa9\x01\x83>\x95~\xb5>\x0c\x8c\x8c>i\xc2\x89>a$\x8b>\xc8\xb9\x80>\xbf\xbe\x90>\x01\xcb\x8a>{\x05k>_*}>5\xc7\x95>I\xfd\x82>\xe5\x05\x97>\xc6\xf0\x98>\xc8\xee}>\x04\x82\x88>=\xa0X>\xb3\xdbT>\x82\x91\x80>\xfc\xd6w>qQw>\x18[\x8c>\xe1\x01\xbe>%+\x91>\xe9SR>\x96\xd5|>\x13\t\x8e>?\xed\x92>\x13~\xa1>\x10\x1c\x91>O\xd9\xa2>\n\xf7\xa4>+\xba\xb8>W\x16\xb9>\x7f\x0b\x81>\xaaP\xa5>?{\x8e>0\xf5\x8e>4\xf1\x93>\xbeZz>\xd2\x14\x8d>\xb69\xaa>D\x19a>\xee7\x8c>"\xc9\x98>\xe6\xfar>h\x97\x91>\'\xeeu>\x0c\xd6\x81>\x9b\xe6\xa9>X\x0f\x9c>a\xec\xa4>\x17[}>\xe4\xa6\x99>\x861\x8a>\xc3\xaa8>^\xe0\x8b>\x8f\xe2\x84>\x084\x92>:Z\x92>\x95\xe2\x91>Bf>>Q\x88\x8b>\xbf\xe5\x80>\x99\xa8\xa9>C\xb3\x81>\xa1<\x8f>hW\xa7>\xcdn\x8d>N*\x91>\xbc\x8ex>\xfa\xf9\x8f>\xc0\x8d\x9f>q\x08\xaa>G\x8c\x94>_d^>\x9a\x1c\xa5>K\x84\xb3>o^\xa4>\x87\x08\x8b>\xff\xba\x85>\x05\xb7\x89>\xaf\xf2\x92>A\xfa\x99>\xa2\\\x8e>\xab6\x85>Z\xc6\x8c> :\x9a>\x9b\xdb\x99>\x90p\xa6>!\xbe\x9c>Z\xb7\xa8>@\x99\x87>\x03\xcfo>C\\\x96>\x98\x01\xa2>\x1a\xb5\x99>\x95VH>\xab\x8a\x8a>o\x9c\xa7>p\xb3W>\x16\xef\x80>\xd3!\xa1>\x06>n>\xe5A\xbb>g\x83z>\x88\x98\x80>\x16\xa0\x85>E\x82\x8c>~\xc4A>\xd6\x9b\x87>\xb8\x86\x96>\x7fi\x8a>\x9d\x0fk>,~\x97>\xc6\xc7\xa0>\x11\x92\xa7>\xb9\xe4\x93>pKs>\xd0a\x83>Yq\x80>O\x82z>D\xbb\x83>\xc2\x8a\x80>f\x02s>3\xa9\xb2>\x18\x1f\x8f>\xd2\x8c\x94>\x9c\xfc\x8d>\x87\xe0q>K\x81~>\xd8y\x93>\xc5\xbb\x8d>\x04\x05\x9a>~\xd2\x83>t;y>Q_\x9b>\xa7z\x80>\xad\xbf\x95>\xca\xf7\xa4>\xa3\x80\x94>a\x0b\x97>H\xfbx>\x17\'\x9a>\xd5\xcf\x95>@(r>\xef\xd6\xa4>7\xaa\x98>\x05s\x97>Y|\x90>\xfd5\x8d>\xd1Ev>G\xbf\x9f>\xfa\x88\x82>\x9d\x85\x82>\xd3\xbc\x8e>\xc0\xf8\x94>]\x93\xa8>-\xc1u>\xa1bj>\x851\x83>;H}>\xdbM\xa2>\x97\xb3v>\x1d\xa1\x91>\xc0\xd9\xad>Q\xa6\x8b>\xc3\xad\xb0>\xed\x9d\x9a>x\x98\x88>\t\x82T>\x87\xfb\x8b>\xd8C\x9a>\x8f\x9e\xb5>+\xa5\xa2>lZ\x8d>\xf1\xafz>\x01\xe9\x93>\x0f\xf0\xc6>\x00u\x98>\xa1\xaf\x98>\xc1\xb7\x97>`\x9d\xa8>]^\xa2>u\xa7\xbc>}+k>\x02\n\x85>\x92\x87h>B\x9f\x8f>\xa0g\x82>\xa7Qq>\x15\xe7_>A\xd7~>\x9f\x83\x9d>\xa6p|>)\xcc\x9b>\xeb\xe1\x92>An\x8b>"H\x84>\xf28w>=\xce\x9c>&\xe9\x8c>\xfaWY>j%\x94>\x80)\xaa> Fi>\xf1d\xa3>\x16\x16\xad>\xc4\xf8\x88>\xed\x18\x9e>\xcc<\xa2>G\xb1\x93>\xe2\xf7\x99>\xf7.z>\xdf\xd1~>L\xa0\x87>\x06\\\x98>\x927\x82>\x11H\x84>\xa7\xb6\x95>\xbfxr>\xd3\x9f\x8c>$\xba\x87>\xae2\xa2>H\xcd\xac>\xd1\xff\x99>`8\x8c>0\x11\x9f>\xb9O\x99>F\xcb\xa8>Lb\xa0>4\xf7\x99>Nq\x8f>\xa4N\x98>\xbf\xa8\x80>[\x8c\xa5>\x00V\x9e>\xe1\xc4\x85>\xb0Zk>XQQ>\xfd\xea\xb2>\xb8\t\xae>\x8a\x85\xda>\x07\x96\x82>\x10,\x84>\xf1\xb8\xa1>\x16\xcb\xae>\xea\x1e\x9d>\x81p\x7f>0e\xaf>\xf2j\xa0>x\xa2\xa3>S\xf3\x8e>Ky\xa3>v\x98\x8f>\x16,M>kg\x8f>)`m>\xbaCd>\xad\xf9\xc6>\xa2\x10\x90>P\xca\x96>\xde4\xc4>U]z>\xf4\\\xaf>\xed `>\xe1\x01\x9d>H6\x81>\x01?\x9e>6{\x85>7\xea\xa0>\xb9\xa6\x87>\xc7\xe4\x89>\xb2\xaf\x9d>\xe4\xac\x89>\x15*\xcd>\xe3\xfa\xae>2/\x89>\x02\xf3\x99>B\xdb\x9c>'  # noqa
            }
        ]
        reducer = join_scores.MaxFeatureReducer(ext_id_key='external_id')
        generator = RecordsGenerator([input_records])
        result_records = list(reducer({'external_id': '111'}, generator))
        expected_records = [
            {
                'external_id': '111',
                'features': b'g\xa5\x88>Z\x8e\xa9>SR\x92>\xb1\xf7\x81>n\x87\xaa>\x1f\xcbe>\xa0d\x96>x\x11\x9a>Vpy> \xbd\x9e>\xe3\xa3\x80>na\xa2>?M\x98>n\\\x96>:i\x90>\xe8\x8e\x88>\xa1&\x8c>\xef\x8d\x92>3\x9f\x9a>n{\xa9>(\x8a\x8a>\xa5\xd1\x84>V\xa6\x80>\x93$\x87>\xd9&v>3d\xa8>\x0e\xd3\x95>\x9f\xa3\x92>\x91V\x8b>\x8d\xaeP>\\\x01\xaf>3\xfe\x92>\xc2\x83\x81>.Q\x95>)n\x90>\xd0\x96\xa2>\xe3\xdd\x9a>\xb8\x95\xaa>\xb3\xba\x81>=\x86\x99>\xa2@}>\x02\xc8\x80>4\xf4\xa4>\xbbo\xa8>\xc9\xd0\x84>\xbc]\xb9>\x87\x1d\x99>I\xb3\x92>!\xbc\x9c>\t\xb3\x9d>[E\x9b>\xe5\xbe\x89>2z\x89>\xaf]\x87>\xc7\xef\xa1>\xebb\x86>\xe0\xb3w>\xc6y\xaf>\xd8\xf8\x80>EZr>\x85^\x8b>\xaf\xe3\x90>(w\x9f>l%\xa2>\x1a\xe0\x8f>}\x1a\xa5>G"\x81>x\t\x9d>!N\xba>{\x1c\x9a>X\x15\x8f>\xbe\x91p>\xd0(\x8a>]@\x8d><k\xab>\xd6r\xa5>y\x96l>&\xfa|>Fu\x8c>\xb3\xeb\x96>\x8cY\x8a>\xf1h\xb3>-\xcf\x84>0\xbb\x94>5\xde\x82>\x8f\xe4\xab>\xe9\xb2\x94>1\xb4\x92>l\xc4\x8d>hI\x9d>\xd7\x82\xb0>\xaa\x9f\xa8>\xbf\xa4\x7f>}\x90\x95>_r\x8c>\xbb\x9bk>\xd8\xd1a>!\x12\x8e>\xef\x90\xa6>\x13\x10\xaa>c\x85\x81>\x1c\xb4w>M\xa5c>\xe6\xef\x94>3E\xa2>K\xe7\x9b>3\x82\xb1>>B\x9c>9\x80\x86>[O\x90>\xeaI\xaa>\xc5\xd3\xa8>\xd57\x91>\np\x82>\x96\x9b\xbb>1\x8av>\xa5I\x8c>X4\x97>\xc5\n\x8b>k&\x87>\xa9\x01\x83>\x95~\xb5>\xee\x98\x93>-P\x9f>a$\x8b>\xc8\xb9\x80>\xad\x7f\x92>\xf7T\x94>8\xb6\x92>\xcc4\x82>5\xc7\x95>I\xfd\x82>\xe5\x05\x97>\x8f6\xa1>{h\x9c>\xce.\x91>\xde\xa1u>\r\xdcu>\xd6\x9c\x8d>\xe9\x1e\x9c>\x0f\xd8\x80>\x18[\x8c>\xe1\x01\xbe>%+\x91>\xe8\xf2\x8b>\x96\xd5|>\xe8R\x9c>?\xed\x92>\x13~\xa1>\xc5\xa1\x97>O\xd9\xa2>\n\xf7\xa4>+\xba\xb8>\x19\xaf\xd3>\x7f\x0b\x81>\xaaP\xa5>?{\x8e>"\x8c\x8f>%\x9c\x9e>\xbeZz>\xd2\x14\x8d>\xb69\xaa>X\xca\x86>\xaaq\x9e>"\xc9\x98>\xe6\xfar>h\x97\x91>u)y>%R\x84>\x9b\xe6\xa9>X\x0f\x9c>a\xec\xa4>\x17[}>\xf4?\xa7>\x861\x8a>\x109h>\xc1\x13\x90>\x8f\xe2\x84>\x084\x92>:Z\x92>\x95\xe2\x91>\xb34J>Q\x88\x8b>K\xf6\x9f>\x99\xa8\xa9>\xdc\x08\x97>\xe14\xb7>hW\xa7>\xa2=\x8f>~\xf2\x93>\xbc\x8ex>\xfa\xf9\x8f>\x99\x0c\xb0>q\x08\xaa>G\x8c\x94>_d^>\x9a\x1c\xa5>K\x84\xb3>o^\xa4>\x87\x08\x8b>\xfd\x1a\x98>\x05\xb7\x89>\xaf\xf2\x92>A\xfa\x99>\xa2\\\x8e>\xab6\x85>Z\xc6\x8c> :\x9a>\x9b\xdb\x99>\x90p\xa6>!\xbe\x9c>Z\xb7\xa8>@\x99\x87>\x03\xcfo>N\x81\x97>\x98\x01\xa2>\x1a\xb5\x99>^j`>\x1d\x16\xa8>o\x9c\xa7>p\xb3W>\x10$\x99>\xd3!\xa1>\x06>n>\xe5A\xbb>Z6{>\xcb\xd0\x9e>\x16\xa0\x85>E\x82\x8c>-\xb7\x83>\xd6\x9b\x87>\xb8\x86\x96>\x7fi\x8a>2\xa5\x92>,~\x97>\xc6\xc7\xa0>\x11\x92\xa7>NW\x9e>pKs>\xd0a\x83>Yq\x80>O\x82z>D\xbb\x83>\xc2\x8a\x80>f\x02s>3\xa9\xb2>\xbc\xb6\xa9>\xd2\x8c\x94>\xd7i\xa3>\x9aW\x95>\x8d{\x8a>\xd8y\x93>\xc5\xbb\x8d>\x04\x05\x9a>\x00\xd2\x84>\xfc%\x8d>Q_\x9b>\xb0\x0c\x8d>\xad\xbf\x95>\x1eH\xa8>\xf3\xc4\xb5>a\x0b\x97>\x06\xe5\x87>\x17\'\x9a>,\x00\xb2>J\x1a\x96>\xef\xd6\xa4>7\xaa\x98>\x05s\x97> J\x9d>U\xf0\x9b>\xd1Ev>\xa4(\xa7>\xfa\x88\x82>\x9d\x85\x82>\xd3\xbc\x8e>\xc0\xf8\x94>]\x93\xa8>\x13\xd2\x8e>\xa1bj>\x851\x83>;H}>\xdbM\xa2>+\x15\x8e>\x0eQ\x98>\xc0\xd9\xad>\x0ce\x8d>\xc3\xad\xb0>\xed\x9d\x9a>x\x98\x88>\t\x82T>\x87\xfb\x8b>\xd8C\x9a>\x8f\x9e\xb5>+\xa5\xa2>lZ\x8d>\x10E}>*\x80\x95>\x0f\xf0\xc6>\x00u\x98>}b\xa5>\xc1\xb7\x97>`\x9d\xa8>]^\xa2>u\xa7\xbc>\x9b\x7f\x93>\x02\n\x85>\x92\x87h>\x84F\x91>\xa0g\x82>\xa7Qq>\xf7\x05\x7f>A\xd7~>3\\\xa5>pW\x85>)\xcc\x9b>\xeb\xe1\x92>\x03m\x96>"H\x84>\xf28w>r@\xae>\n#\x90>\xfaWY>j%\x94>\x80)\xaa>\xf3\x90i>\xf1d\xa3>\x16\x16\xad>\xc4\xf8\x88>\xed\x18\x9e>\xcc<\xa2>G\xb1\x93>\xe2\xf7\x99>\xf7.z>\xdf\xd1~>\xe0\xb6\x8c>\x06\\\x98>\x927\x82>\xca~\xa8>\xa7\xb6\x95>\xbfxr>\xd3\x9f\x8c>7*\x8e>\xae2\xa2>H\xcd\xac>\xd1\xff\x99>\xa2\x02\x96>H\x88\xa0>\xb9O\x99>F\xcb\xa8>Lb\xa0>\x10;\x9e>Zv\x9c>\xa4N\x98>\xbf\xa8\x80>\xd9S\xb6>\x00V\x9e>\xe1\xc4\x85>\xb0Zk>\xe35\x9a>\xfd\xea\xb2>\xb8\t\xae>\x8a\x85\xda>\xbf\x19\x8d>\x10,\x84>\xf1\xb8\xa1>\x16\xcb\xae>\xea\x1e\x9d>\x93\xda\x80>0e\xaf>\xf2j\xa0>x\xa2\xa3>S\xf3\x8e>Ky\xa3>v\x98\x8f>\x16,M>\xbbk\x9b>\x07\xe3x>\xbaCd>\xad\xf9\xc6>;\x85\xa1>P\xca\x96>\xde4\xc4>U]z>\xf4\\\xaf>\xed `>\xe1\x01\x9d>H6\x81>\x01?\x9e>\xc9\xd7\x8c>7\xea\xa0>\x19c\xbb>\xc7\xe4\x89>?\xb7\x9d>\xe4\xac\x89>\x15*\xcd>\xe3\xfa\xae>\x8b\xdb\xa3>\x02\xf3\x99>B\xdb\x9c>'  # noqa
            }
        ]
        self.assertEqual(result_records, expected_records)


if __name__ == '__main__':
    unittest.main()
