# import os
# import lightgbm
# from sklearn.model_selection import train_test_split
# from sklearn.metrics import roc_auc_score
# from sklearn.model_selection import StratifiedKFold
#
#
# def train(X, y, categorical_features, model_name):
#     X_train, X_test, y_train, y_test = train_test_split(X, y, random_state=42)
#     train_data = lightgbm.Dataset(X_train, y_train, categorical_feature=categorical_features)
#     test_data = lightgbm.Dataset(X_test, y_test, categorical_feature=categorical_features)
#
#     parameters = {
#         'application': 'binary',
#         'objective': 'binary',
#         'metric': ['auc', 'logloss'],
#         'learning_rate': 0.01,
#         'bagging_freq': 3,
#         'bagging_fraction': 0.8,
#         'min_data_in_leaf': 30,
#         'min_sum_hessian_in_leaf': 5,
#         'use_two_round_loading': False,
#         'feature_fraction': 0.8,
#         'verbose': 1,
#         'num_threads': 30,
#         'lambda_l1': 0.1
#     }
#
#     model = lightgbm.train(parameters,
#                            train_data,
#                            valid_sets=[test_data, train_data],
#                            valid_names=['eval', 'train'],
#                            num_boost_round=5000,
#                            early_stopping_rounds=100)
#
#     preds_train = model.predict(X_train, num_iteration=model.best_iteration)
#     preds_test = model.predict(X_test, num_iteration=model.best_iteration)
#     if not os.path.exists('models'):
#         os.mkdir('models')
#     model.save_model('models/{}.txt'.format(model_name))
#     results = {
#         'eval AUC': roc_auc_score(y_test, preds_test),
#         'train AUC': roc_auc_score(y_train, preds_train),
#     }
#     return model, results
#
#
# def train_folds(X, y, categorical_features, model_name, n_folds=5, random_state=100):
#     skf = StratifiedKFold(n_splits=n_folds, random_state=random_state)
#     results = {
#         'eval AUC': [],
#         'train AUC': [],
#         'early_stopping': []
#     }
#     models = []
#     for train_index, val_index in skf.split(X, y):
#         X_train = X[train_index, :]
#         y_train = y[train_index]
#         X_val = X[val_index, :]
#         y_val = y[val_index]
#         train_data = lightgbm.Dataset(X_train, y_train, categorical_feature=categorical_features)
#         test_data = lightgbm.Dataset(X_val, y_val, categorical_feature=categorical_features)
#
#         parameters = {
#             'application': 'binary',
#             'objective': 'binary',
#             'metric': ['auc', 'logloss'],
#             'learning_rate': 0.01,
#             'bagging_freq': 3,
#             'bagging_fraction': 0.8,
#             'min_data_in_leaf': 30,
#             'min_sum_hessian_in_leaf': 5,
#             'use_two_round_loading': False,
#             'feature_fraction': 0.8,
#             'verbose': 1,
#             'num_threads': 30,
#             'lambda_l1': 0.1
#         }
#
#         model = lightgbm.train(parameters,
#                                train_data,
#                                valid_sets=[test_data, train_data],
#                                valid_names=['eval', 'train'],
#                                num_boost_round=5000,
#                                early_stopping_rounds=100)
#
#         pred_train = model.predict(X_val, num_iteration=model.best_iteration)
#         pred_test = model.predict(X_val, num_iteration=model.best_iteration)
#         models.append(model)
#         results['eval AUC'].append(pred_test)
#         results['train AUC'].append(pred_train)
#     if not os.path.exists('models'):
#         os.mkdir('models')
#     model.save_model('models/{}.txt'.format(model_name))
#
#     return models, results
#
#
# def predict(X, model):
#
#     if isinstance(model, str):
#         model = lightgbm.Booster(model_file='{}.txt'.format(model))
#
#     return model.predict(X)
