from datacloud.dev_utils.data.data_utils import array_tostring

DEFAUL_NULL_VALUE = -1


def df_to_yt(df):
    for index, row in df.iterrows():
        yield row.to_dict()


class FeaturesMapper:
    def __init__(self, ext_id_key, columns, null_value=DEFAUL_NULL_VALUE):
        self.ext_id_key = ext_id_key
        self.columns = columns
        self.null_value = float(null_value)

    def __call__(self, rec):
        features = []
        for col in self.columns:
            if rec[col] is None:
                features.append(self.null_value)
            else:
                features.append(float(rec[col]))
        yield {self.ext_id_key: rec[self.ext_id_key], 'features': array_tostring(features)}
