from yt.wrapper import ypath_join, TablePath
from datacloud.config.yt import DATACLOUD_FOLDER, CRYPTA_SNAPSHOT_FOLDER, AGGREGATES_FOLDER
from datacloud.dev_utils.yt import features


class PhoneRangeBuildConfig(object):

    def __init__(
        self,
        root=None,
        tag='PHONERANGE',
        use_cloud_nodes=False,
        pure_external_id=False,
        compute_region_changes=True,
        is_retro=True,
        snapshot_date=None
    ):
        self.root = root
        self.tag = tag
        self.use_cloud_nodes = use_cloud_nodes
        self.compute_region_changes = compute_region_changes
        self.pure_external_id = pure_external_id
        self.phone_ranges_info = ypath_join(DATACLOUD_FOLDER, 'phone_static_data/phone_ranges_info')
        self.rainbow_table = ypath_join(DATACLOUD_FOLDER, 'phone_static_data/rainbow-phone-md5')
        self.is_retro = is_retro

        if self.is_retro:
            self.ext_id_key = 'external_id'
            self.input_table = TablePath(
                ypath_join(root, 'get_yuids/input')
            )
            self.raw_data_table = TablePath(
                ypath_join(root, 'raw_data/table')
            )
            self.data_dir = ypath_join(root, 'datacloud/aggregates/phone_range')
            self.clickstream_region_table = ypath_join(root, 'datacloud/aggregates/time_hist/timezone')
            self.features_table_path = ypath_join(self.data_dir, 'features')
        else:
            self.ext_id_key = 'cid'
            self.snapshot_date = snapshot_date
            self.input_table = ypath_join(CRYPTA_SNAPSHOT_FOLDER, self.snapshot_date, 'phone_id_value_to_cid')
            self.data_dir = ypath_join(AGGREGATES_FOLDER, 'phone_range', self.snapshot_date)
            self.clickstream_region_table = ypath_join(AGGREGATES_FOLDER, 'time_hist', self.snapshot_date, 'timezone')
            self.features_table_path = ypath_join(self.data_dir, 'features')

        schema = [
            {'name': self.ext_id_key, 'type': 'string'},
            {'name': 'operator', 'type': 'string'},
            {'name': 'region', 'type': 'string'},
            {'name': 'region_id', 'type': 'int32'},
        ]
        self.features_table = TablePath(
            self.features_table_path,
            attributes=dict(schema=schema)
        )

    @property
    def cloud_nodes_spec(self):
        return features.cloud_nodes_spec(self.use_cloud_nodes)
