import murmurhash
import numpy as np


_INT32_MAX = 2147483647
_DEFAULT_REGION_ID = -1
_DEFAULT_CHANGE_REGION = -1
_DEFAULT_OPERATOR = -1


def extract_phone_range_features(rec):
    region_id = rec['region_id']
    if region_id is None:
        region_id = _DEFAULT_REGION_ID
    change_region = rec['change_region']
    if change_region is None:
        change_region = _DEFAULT_CHANGE_REGION
    change_region = int(change_region)
    operator = rec['operator']
    if operator is None:
        operator = _DEFAULT_OPERATOR
    else:
        # to store in int32
        operator = murmurhash.hash64(operator) % _INT32_MAX
    return np.array([region_id, change_region, operator], dtype=float)
