# INPUT CHECKER #
Утилита для валидации входных CSV файлов. Читает построчно файл, применяет правила валидации и сообщает о найденных ошибках. 

## Параметры запуска ##
Все параметры являются необязательными. В качестве входного файла по-умолчанию будет взят выходной файл normalaizer'а

- ```-h --help``` -- Показать хелп утилиты
- ```-f FILE, --file FILE``` -- Путь до входного файла, который надо валидировать
- ```-d {;,comma,tab,space}, --delimiter {;,comma,tab,space}``` -- Разделитель, используемый во входном файле (по умолчанию таб)
- ```-ul, --use-list``` Флаг. Сначала отвалидировать весь файл, затем писать сообщения об ошибках (в противном случае ошибки буду выводиться сразу при обнаружении)
- ```-s, --summary``` Флаг. Вывести только короткое резюме (summary) о валидации с количеством ошибок без вывода самих ошибок
- ```-l LIMIT, --limit LIMIT``` Число. Лимит на количество ошибок, после которого валидатор остановится
- ```-hh, --hard-headers-check``` Жесткая проверка заголовка (что он не содержит никаких дополнительных полей, только поля из спецификации)

Получить справку по параметрам запуска:
```bash
./input_checker --help
```

## Новые правила проверки ##
Новые правила добавляются в методе get_xprod_validator.
**add_value_check_if_exists** -- дообавить правило на поле, но только если поле будет в CSV файле
**add_value_check** -- добавить правило на поле (поле становится обязательным)

## Информация для разработчика ##
Чекер будет требовать, чтобы файл содержал хотя бы 1 столбец с идентификатором. Чтобы дополнить список столбцов-идентификаторов, надо поправить константу **id_fields** (файл constants.py). Не забудьте добавить новое поле также в **allowed_headers**.
