# -*- coding: utf-8 -*-
import csv
import sys

from datacloud.dev_utils.validators.csv_validator import write_problems
from datacloud.input_pipeline.input_checker.helpers import get_args, get_xprod_validator


def validate_csv(
        full_path_to_file,
        delimiter='\t',
        use_list=False,
        summarize=False,
        limit=None,
        hard_headers=False):

    validator = get_xprod_validator(full_path_to_file, delimiter, hard_headers=hard_headers)

    with open(full_path_to_file, 'rb') as csv_file:
        data = csv.reader(csv_file, delimiter=delimiter)
        if not use_list:
            problems = validator.ivalidate_xprod(data, summarize=summarize)
        else:
            problems = validator.validate_xprod(data, summarize=summarize, limit=limit)
        write_problems(problems, sys.stdout, summarize=summarize, limit=limit)
        validator.write_unique_accum(sys.stdout)


def main():
    delimiter, full_path_to_file, use_list, summarize, limit, hard_headers = get_args()

    validate_csv(
        full_path_to_file=full_path_to_file,
        delimiter=delimiter,
        use_list=use_list,
        summarize=summarize,
        limit=limit,
        hard_headers=hard_headers
    )


if __name__ == '__main__':
    main()
