# INPUT PIPELINE #
Модуль, отвечающий за непоседственный запуск пайплайна. На вход ему подается TSV файл и JSON с описанием запуска. Весь процесс расчета будет производиться на YT, не требуя от запускающей машины большого количества ресурсов.

## Описание параметров конфига ##

### Обязательные ###
- **PARTNER_ID** -- название партнера (напр. "raiff")
- **TICKET_NAME** -- название тикета в Startrek
- **PATH_TO_CSV** -- путь до директории, содержащей CSV файл
- **INPUT_FILE** -- имя исходного файла, полученного от партнера (должен лежать в директории PATH_TO_CSV). Файл будет загружен на YT "as is"
- **NORMALIZED_FILE** -- имя файла, полученного после нормализации исходного (должен лежать в директории PATH_TO_CSV). Должен быть в формате TSV (по-умолчанию). Может совпадать с INPUT_FILE.
- **RETRO_TAG** -- Уникальный идентификатор запуска. Необходим для исключения коллизий в директориях с временными таблицами
- **IS_CREDIT_SCORING** -- Является ли запуск кредитным скорингом. Нужен для проставления тэга в Startrek. Boolean

### НЕ Обязательные ###
- **ST_TOKEN** --  Startrek Token. Если не указан, то код попробует взять его из переменной окружения ST_TOKEN, а также из pykeymanager
- **NIRVANA_TOKEN** -- Nirvana Token. Если не указан, то код попробует взять его из переменной окружения NIRVANA_TOKEN, а также из pykeymanager
- **USE_CLOUD_NODES** -- Включать ли облачные ноды. Может ускорить выполнение.
- **FORCE_GREP** -- Игнорировать уже существующие логи в папке "grep"
- **NORMALIZED_DELIMITER** -- Разделитель нормализованного файла. Tab по-умолчанию
- **METADATA_TABLE** -- Путь до таблицы, где хранятся метаданные запусков
- **HISTORY_TABLE** -- Путь до исторической таблицы
- **HISTORY_TARGET** -- Название колонки, которую брать для исторической таблицы (по-умолчанию def_6_60)
- **FMT_DATA_DIR** -- Путь до рабочей директории. ('//projects/scoring/{0}/{1}' по-умолчанию. 0 -- партнер, 1 -- тикет)
- **MONTH_DELTA** -- На сколько месяцев назад брать логи
- **DSSM_MODEL_URL** -- Путь на YT (или Sandbox) до используемой DSSM модели. Указывается в YQL формате (см. по коду)
- **SHUT_UP_ST_BOT** -- Не писать отчет о выполнении паплайна ботом в Startrek
- **ST_FORCE_NEW_COMMENT** -- Не исправлять существующий коммент, а созздать новый
- **PATH_TO_TAKE_MODEL_FROM** -- Откуда брать модель для применения. Может быть локальным путем, либо путем на YT. В последнем случае необходимо добавить специальный префикс 'yt:' (напр. 'yt://home/x-products/my_nice_mydel')
- **APPLY_TAG** -- Тэг, который добавить к папке, куда будут размещены результаты применения
- **APPLY_FOR_FEATURES** -- Название таблицы с признакми, к которой применять модель
- **APPLY_MODEL** -- Название модели, которую необходимо применить. Если указано, путь до бинарника модели и название признаков будут взяты из специальной дин. таблицы.
- **USE_CRYPTA_SNAPSHOT** -- Исопльзовать ли Crypta Snapshot (должен быть выключен, если используется кастомная крипта)
- **PATH_TO_CUSTOM_CRYPTA** -- Путь до кастомной крипты
- **STEPS** -- Шаги, которые необходимо выполнить
- **EXCLUDE_STEPS** -- Шаги, которые необходимо исключить из выполнения (имеет более высокий приоритет, чем STEPS)
- **NIRVANA_WF_ID** -- Workflow, в котором запускать граф обучения
- **SECRETS_FILE** -- Файл с секретами. Может использоваться вместо переменных окружения
- **STREAM_LOGS_TO_FILE** -- Писать ли логи в файл
- **LOG_FILE** -- Название файла, куда писать логи
- **TAGS** -- Тэги, которые нужно проставить тикету в Startrek
- **YT_TOKEN** -- Использовать указанный Yt Token

### Шаги подготовки признаков ###
В пайплайне существует возможность задавать набор шагов по сбору признаков, которые необходимо выполнить. Шаги можно задать как списком, так и одним числом. В случае списка будут выполнены шаги с указанными индексом (0 -- самый первый шаг). В случае числа будут выполнены все шаги с индексами больше либо равными указанному.
- **CLUST_STEPS** -- шаги кластерных признаков
- **DSSM_STEPS** -- шаги DSSM признаков
- **GEO_STEPS** -- шаги GEO признаков
- **TIMEHIST_STEPS** -- шаги Time hist признаков
- **PHONERANGE_STEPS** -- шаги Phone range признаков

### Параметры подготовки GEO признаков ###
- **MAX_DISTANCES_IN_CATEGORY** -- сколько использовать расстояний до ближайших точек по каждой категории
- **GEO_DIST_THRESH** -- порог для бинарных признаков (был в радиусе / не был)
- **ADDRS_TYPES** -- типы адресов (HOME, REG, WORK по-умолчанию)
- **GEO_FEATURES_FILLNA** -- чем заполнять пропуски гео признаков (0 по-умолчанию)
- **GEO_FEATURES_SORT_ORDER** -- в каком порядке должны быть отсортированы расстояния (по убыванию по-умолчанию)
- **RESOLVE_N_JOBS** -- во соклько потоков обстреливать Геокодер
- **RESOLVE_MEMORY_ON** -- запоминать ли адреса (чтобы не запрашивать повторно)
- **RESOLVE_LOAD_VERBOSE** -- Verbose у загрузки данных для обстрела геокодера
- **RESOLVE_PARALLEL_VERBOSE** -- Verbose у обстрела Геодкодера

### Параметры подготовки Phone Range признаков ###
- **PHONERANGE_PURE_EXTERNAL_ID** -- Должен быть выставлен в False для тикетов >= XPROD-1517

### Параметры, которые вряд ли пригодятся ###
- **INPUT_DELIMITER** -- Разделитель воходного файла. Tab по-умолчанию
- **AUDIENCE_CUSTOM_BASE_ROOT** -- Путь до кастомной папки с аудиториями (напр. '//projects/scoring/bystrobank')
- **AUDIENCE_SUMMARY_ONCE** -- Раз во сколько строк печатать сообщение при загрузке аудитории
- **RAW_DATA_DIR** -- Название директории, куда класть исходные CSV
- **RAW_DATA_TABLE** -- Название таблицы с исходными данными
- **GLUED_RAW_TABLE** -- Название таблицы со склеенными external_id, retro_date
- **METADATA_TABLE_SCHEMA** -- Схема таблицы с метаданными
- **TICKET_SUFFIX** -- Какой-то suffix из Audience
- **INPUT_BASE_SCHEMA** -- Схема таблицы input
- **HISTORY_TABLE_SCHEMA** -- Схема исторической таблицы
- **AUDIENCE_TIME_FORMAT** -- Формат даты для Audience
- **DEFAULT_AUDIENCE_DIR** -- Путь до Audience
- **GREP_DIR** -- Путь до директории с логами
- **MIN_GREP_DATE** -- Дата, ранее которой логи брать не надо
- **CLUSTER_CENTRES_TABLE** -- Путь до таблицы с центрами кластеров
- **FEATURES_PROD_SCHEMA** -- Схема таблицы с признаками
- **FEATURES_PROD** -- Какая таблица с признаками является основной для подсчета статистик (хита)
- **YT_TRAIN_FOLDER** -- В какую папку класть результаты обучения моделей
- **TMP_FOLDER** -- Папка для временных таблиц
- **ST_BASE_URL** -- URL Startrek
- **ST_USER_AGENT** -- Useragent Startrek
- **VERBOSE_IN_MODEL_APPLY** -- Verbose во время применения модели
- **NIRVANA_QUOTA** -- Квота при запуске пайплайна в Нирване
- **NIRVANA_YT_SECRET** -- Название YT секрета. Нужен при запуске пайплайна в Нирване
- **NIRVANA_ST_SECRET** -- Название Startrek секрета. Нужен при запуске пайплайна в Нирване
- **NIRVANA_NIRVANA_SECRET** -- Название Nirvana секрета. Нужен при запуске пайплайна в Нирване


## Описание шагов ##
- **run_raw_upload** -- Загрузить входные таблицы на YT. Создать необходимые директории. ПРовести минимальную подготовку
- **run_append_meta_table** -- Добавить мета данные запуска в специальную таблицу. Будет расчитан ряд статистик (напр. количество строк с непустым телефоном)
- **run_merge_audience** -- Добавить данные в специальную таблицу Audience
- **run_make_input** -- Создать таблицу input из входных данных
- **run_make_all_yuid** -- Приджойнить к таблице input yuid'ы с помощью склейки Крипты
- **run_metadata_all_yuid** -- Посчитать метаданные по yuid'ам
- **run_map_meta_data_to_comment** -- Отобразить содержимое метаданных в коммент в Startrek. Рекомендуется выполнять этот шаг после всякого изменения метаданных, чтобы всегда получать актуальные апдейты.
- **run_grep** -- Собрать Spy и Watch логи
- **run_calc_cluster_features** -- Посчитать кластерные признаки
- **run_calc_dssm_features** -- Посчитать DSSM признаки
- **run_grep_geo** -- Собрать Geo логи
- **run_calc_geo_features** -- Посчитать GEO признаки. Соберет Geo логи, если они еще не были собраны
- **run_calc_locations_features** -- Посчитать LOCATIONS признаки (посещенные страны, регионы, районы; дом-работа)
- **run_calc_time_hist_features** -- Посчитать Исторические признаки
- **run_calc_phone_range_features** -- Посчитать Phone Range признаки
- **run_calc_contact_actions_features** -- Посчиатть Contact Actions признаки
- **run_combine_features** -- Склеить таблицы с признакми в одну. Будет создано несколько таблиц для разных комбинаций признаков. External id в этих таблицах будут пересечением external_id из отдельных таблиц
- **run_append_history_table** -- Добавить данные в историческую таблицу
- **run_metadata_features_prod** -- Обновить метаданные после расчета признаков (посчитать хит)
- **run_apply_model** -- Применить предобученные модели к посчитанным признакам
- **run_train_nirvana** -- Запустить обучение в Нирване (будет запущено обучение для всех групп признаков). Процесс в Нирване будет происходит фоном, не блокирую работу запускающей машины. По итогам обучения бот напишет сообщение в Startrek (если такое поведение не было вручную отключено)
- **run_compress** -- Сжать все таблицы + собрать все логи в одну таблицу

Граф зависимости шагов:
![Зависимость шагов](https://jing.yandex-team.ru/files/penguin-diver/G.gv.png)


## Пример типичного запуска ##
```python
from datacloud.input_pipeline import InputPipeLine  # Импортируем пайплайн

params = {
    "PARTNER_ID": "very_nice_partner",  # название партнера
    "TICKET_NAME": "XPROD-9999",  # название тикета

    "PATH_TO_CSV": ".",  # расположим входные файлы рядом с кодом
    "INPUT_FILE": "input_not_normed.csv",  # Файл, полученный от партнера
    "NORMALIZED_FILE": "input_norm.tsv",  # Нормализованный файл

    "RETRO_TAG": "some_fellow-very_nice_partner-XPROD-9999",  # Уникальный тэг запуска
    "STEPS": [
        'run_raw_upload',  # загрузим исходные данные
        'run_append_meta_table',  # посчитаем метаданные и запишем в таблицу
        'run_map_meta_data_to_comment',  # напишем коммент в Startrek
        'run_merge_audience',  # Допишем данные в таблицу Audience
        'run_make_input',  # Создадим таблицу Input
        'run_make_all_yuid',  # Приджойним yuid'ы через Крипту
        'run_metadata_all_yuid',  # Посчитаем метаданные yuid'ов
        'run_map_meta_data_to_comment',  # Напишем коммент в Startrek
        'run_grep',  # Погрепаем логи
        'run_compress',  # Сожмем все таблицы
        'run_calc_cluster_features',  # Посчитаем кластерные признаки
        'run_calc_dssm_features',  # Посчитаем DSSM признаки
        'run_combine_features',  # Склеиваем признаки в финальные таблицы
        'run_metadata_features_prod',  # Посчитаем метаданные по признакам
        'run_map_meta_data_to_comment',  # Напишем коммент в Startrek
        'run_train_nirvana',  # Запустим обучение в Нирване
        'run_compress'  # Сожмем все таблицы
    ],

    "USE_CLOUD_NODES": True,  # используем облачные ноды
    "IS_CREDIT_SCORING": False,  # НЕ кредитный скоринг
}

pipeline = InputPipeLine.from_dict(params)  # Создаем пайплайн из конфига
pipeline.run_pipeline()  # Запускаем расчет
```

## Запуск пайплайна в Нирване ##
Существует возмжность запустить пайплайн в нирване. Каждый шаг будет упакован в свой кубик с помощью Вальгаллы. Обучение при этом будет работать по-старому (т.е. граф создаст другой граф).

Пример запуска:
```python
pipeline.run_pipeline('nirvana')
pipeline.nirvana_link  # получить ссылку на запущенный граф в Нирване
pipeline.is_done()  # проверить, выполнен ли граф
```
