# -*- coding: utf-8 -*-
import argparse
import os

from datacloud.input_pipeline.input_pipeline.input_pipeline import InputPipeLine
from datacloud.input_pipeline.input_pipeline.constants import CONFIGS_DIR

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument(
        '-c',
        help='path to config file',
        required=True
    )
    parser.add_argument(
        '-a',
        '--absolute',
        action='store_true',
        help='Use absolute path to config'
    )
    args = parser.parse_args()
    if args.absolute:
        config_path = args.c
    else:
        config_path = os.path.join(CONFIGS_DIR, args.c)

    pipeline = InputPipeLine.from_file(config_path)
    pipeline.run_pipeline()
    # pipeline.run_summon_dragons()
