# -*- coding: utf-8 -*-
from textwrap import dedent
from yt.wrapper import ypath_join


def get_select_query(data_dir, grep_dir, input_yuid,
                     log_name, date_from, date_to):
    return dedent("""\
        SELECT
            big_log.yuid as yuid,
            input_yuid.external_id as external_id,
            big_log.`timestamp` as `timestamp`,
            big_log.title as title,
            big_log.url as url
        FROM RANGE(`{grep_dir}/{log_name}`, '{date_from}', '{date_to}') as big_log
        JOIN `{input_yuid}` as input_yuid
        ON input_yuid.yuid == big_log.yuid
        WHERE big_log.`timestamp` < input_yuid.`timestamp`\
    """).format(
        data_dir=data_dir,
        grep_dir=grep_dir,
        input_yuid=input_yuid,
        log_name=log_name,
        date_from=date_from,
        date_to=date_to
    )


def get_grep_query(data_dir, month, log_name, grep_dir, input_yuid=''):
    input_yuid = input_yuid or ypath_join(data_dir, 'input_yuid')
    select_query = get_select_query(
        data_dir=data_dir,
        grep_dir=grep_dir,
        input_yuid=input_yuid,
        log_name=log_name,
        date_from='-'.join((month, '01')),
        date_to='-'.join((month, '31'))
    )

    return dedent("""\
        PRAGMA yt.TemporaryAutoMerge = "disabled";
        PRAGMA yt.JoinMergeUseSmallAsPrimary = "false";
        INSERT INTO `{data_dir}/datacloud/grep/{log_name}/{month}` WITH TRUNCATE
        {select_query}
        ORDER BY external_id, yuid;\
    """).format(
        data_dir=data_dir,
        log_name=log_name,
        month=month,
        select_query=select_query
    )


def get_sort_input_by_yuid_query(data_dir, output_table):
    return dedent("""\
        INSERT INTO `{output_table}` WITH TRUNCATE
        SELECT
            yuid,
            external_id,
            `timestamp`
        FROM `{data_dir}/input_yuid`
        ORDER BY yuid;\
    """).format(
        output_table=output_table,
        data_dir=data_dir
    )
