# -*- coding: utf-8 -*-
from abc import ABCMeta, abstractmethod


class ST_logger_interface:
    __metaclass__ = ABCMeta

    @abstractmethod
    def write_initial_comment(self, ticket_name, input_file):
        pass

    @abstractmethod
    def write_link(self, data_dir):
        pass

    @abstractmethod
    def write_min_max_retro(self, min_retro_date, max_retro_date):
        pass

    @abstractmethod
    def write_contracts_by_month(self, months_dict):
        pass

    @abstractmethod
    def write_tables(self, tables_header, tables_dict):
        pass

    @abstractmethod
    def push(self):
        pass

    @abstractmethod
    def write_train_results(self, results):
        pass

    @abstractmethod
    def drop_message(self):
        pass

    @abstractmethod
    def update_tags(self, partner_id, is_credit_scoring, other_tags):
        pass
