# Normalizer #
Утилита для нормализации входных CSV файлов. Читает строчки из одного файла, применяет правила нормализации и пишет результат в выходной файл.

Нормализатор выполняет следующие действия:
1. Заменяет заголовки файла
2. Нормализует каждое поле, либо целую строку с помощью последовательного применения правил
3. Удаляет строки, являющиеся полными дубликатами друг друга
4. Удаляет строки, в которых нет ни одного поля, по которому можно идентифицировать человека
5. Удаляет строки, у которых дублируется ключевая пара (external_id, retro_date)

## Параметры запуска ##

### Обязательные ###
- ```-f FILE, --file FILE``` -- Путь до входного файла, который надо нормализовать

### Необязательные ###
- ```-h --help``` -- Показать хелп утилиты
- ```-o OUTPUT, --output OUTPUT``` -- Путь до выходного файла. Файл будет записан с разделителем "таб"
- ```-d {;,comma,tab,space}, --delimiter {;,comma,tab,space}``` -- Разделитель, используемый во входном файле (по умолчанию таб)
- ```-ul, --use-list``` -- Флаг использования листа: файл будет сначала полностью обработан, а потом записан на выход. Ставьте его, если хотите, чтобы нормализатор сначала отработал без ошибок и лишь потом начал запись
- ```-l LIMIT, --limit LIMIT``` -- Ограничение на число строк, которые будут выведены в итоговый файл (может быть использовано для быстро проверки корректности работы)
- ```-s SUMMARY, --summary SUMMARY``` -- Раз во сколько нормализованных строк вы хотите получать сообщение о том, что обработчик в процессе
- ```-df DATE_FORMAT, --date-format DATE_FORMAT``` -- Явно указать скрипту, в каком формате записаны ретро даты (например %Y-%m-%d). [Референс со списком доступных тегов](https://strftime.org/)
- ```-hk, --hard-kill``` -- Флаг. Делать null из всех полей, которые не получается привести к нормальному виду (например somebody@yandexru -> null). Без флага нормализатор оставляет такие поля нетронутыми. Также удалит все строчки дубликаты по ключевой паре (external_id, retro_date)
- ```-mdp MAX_DUPS_TO_PRINT, --max-dups-to-print MAX_DUPS_TO_PRINT``` -- Максимальное количество сообщений о найденном дубликате
- ```-mep MAX_EMPTY_TO_PRINT, --max-empty-to-print MAX_EMPTY_TO_PRINT``` -- Максимальное количество сообщений о найденной строчке с пустым набором идентификаторов

Получить справку по параметрам запуска:
```bash
./normalizer --help
```

### Новые правила нормализации ###
Новые правила добавляются в методе get_xprod_normalizer с помощью **add_value_normalizer**.