LIBRARY()

OWNER(g:xprod)

PY_SRCS(
    __init__.py

    input_checker/constants.py
    input_checker/helpers.py
    input_checker/xprod_csv_validator.py
    input_checker/utils/info.py

    input_pipeline/__init__.py
    input_pipeline/audience.py
    input_pipeline/constants.py
    input_pipeline/grep_query.py
    input_pipeline/helpers.py
    input_pipeline/input_pipeline.py
    input_pipeline/pretrained_models_table.py
    input_pipeline/settings.py
    input_pipeline/star_tracker/st_logger_interface.py
    input_pipeline/star_tracker/st_logger.py

    normalizer/constants.py
    normalizer/helpers.py
    normalizer/xprod_csv_normalizer.py
)

PEERDIR(
    datacloud/crypta_utils
    datacloud/features/cluster
    datacloud/features/dssm
    datacloud/features/geo
    datacloud/features/locations
    datacloud/features/time_hist
    datacloud/features/phone_range
    datacloud/features/contact_actions
    datacloud/features/credit_scoring_events
    datacloud/model_applyer/lib
    datacloud/dev_utils
    datacloud/dev_utils/crypta
    datacloud/dev_utils/data
    datacloud/dev_utils/json
    datacloud/dev_utils/validators
    datacloud/ml_utils
    datacloud/data_schema

    contrib/python/future
    contrib/python/scikit-learn
    contrib/python/pandas
    contrib/python/nose
    contrib/python/jsonschema

    library/python/startrek_python_client
    yql/library/python
)

END()

RECURSE(
    input_checker
    input_pipeline
    normalizer
)

