import os
from datacloud.key_manager.files import FilesKeyStorage

__all__ = [
    'set_key_storage',
    'set_default_storage',
    'get_key',
]


_KEY_STORAGE = None


def set_key_storage(storage):
    global _KEY_STORAGE
    _KEY_STORAGE = storage


def set_default_storage(path=None):
    path = path or os.path.join(os.path.expanduser('~'), '.pykeymanager')
    keys = FilesKeyStorage(keys_path=path, files_suffix='.json')
    set_key_storage(keys)


def get_key(*args, **kwargs):
    global _KEY_STORAGE
    if _KEY_STORAGE is None:
        set_default_storage()
    return _KEY_STORAGE.find_key(*args, **kwargs)
