#!/bin/sh

CLUSTERMASTER_URL="http://x-prod-1.haze.yandex.net:3130/"

GIT_PATH=/Berkanavt/git/behavior-triggers-yt
ENV_PATH=$GIT_PATH/.env
KEYS_PATH=$([ -d "$HOME/.pykeymanager" ] && echo "$HOME/.pykeymanager" || echo "/etc/xprod-yt-pipeline/keys")

LAUNCHER_PATH="/xprod_launcher/app"

CLEANER_PATH=$([ -f "$ENV_PATH/bin/xprod-clear-tmp" ] && echo "$ENV_PATH/bin/xprod-clear-tmp" || echo "xprod-clear-tmp")
YT_WORK_CLUSTER=hahn
LAUNCHER_ARGS="--yt-cluster $YT_WORK_CLUSTER --use-yt-cfg --keys-path $KEYS_PATH"
LAUNCHER="$LAUNCHER_PATH $LAUNCHER_ARGS"
CLEANER="$CLEANER_PATH --keys-path $KEYS_PATH"

export YT_LOG_LEVEL=WARNING

_scenario() {
MAIN     = localhost res=cpu:0,mem:0 timeout=86400
SCATTER  = localhost worker1..worker2 res=cpu:0,mem:0 timeout=86400
SCATTER4 = localhost worker1..worker4 res=cpu:0,mem:0 timeout=86400
SCATTER8 = localhost worker1..worker8 res=cpu:0,mem:0 timeout=86400

MAIN apply_models :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="0 * * * *" retry_on_failure="0 * * * *" timeout="86400"

MAIN take_crypta_snapshot :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */2 * * *" retry_on_failure="* */2 * * *"

MAIN dssm_175 :  take_crypta_snapshot mailto=re9ulusv,nryzhikov,penguin-diver

MAIN dssm_175_combine :  dssm_175 mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="0 * * * *" retry_on_failure="0 * * * *" timeout="259200"

MAIN build_geo_logs :  mailto=re9ulusv,nryzhikov,penguin-diver

MAIN build_geo_aggregates :  build_geo_logs mailto=re9ulusv,nryzhikov,penguin-diver

MAIN cluster_hostname_extract :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */2 * * *" retry_on_failure="* */2 * * *"

MAIN cluster_features_2 :  take_crypta_snapshot cluster_hostname_extract mailto=re9ulusv,nryzhikov,penguin-diver

MAIN cluster_features_3 :  cluster_features_2 mailto=re9ulusv,nryzhikov,penguin-diver

MAIN cluster_features_4 :  cluster_features_3 mailto=re9ulusv,nryzhikov,penguin-diver

MAIN grep_spy_watch_logs_extended :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */2 * * *" retry_on_failure="* */2 * * *"

MAIN time_hist_grep :  grep_spy_watch_logs_extended mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */2 * * *" retry_on_failure="* */2 * * *"

MAIN update_crypta_join_tables :  mailto=re9ulusv,nryzhikov,penguin-diver

MAIN check_crypta_stability :  update_crypta_join_tables mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */2 * * *" retry_on_failure="* */2 * * *"

MAIN contact_actions_grep :  grep_spy_watch_logs_extended mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */2 * * *" retry_on_failure="* */2 * * *"

MAIN build_contact_actions_features :  contact_actions_grep take_crypta_snapshot mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */2 * * *" retry_on_failure="* */2 * * *"

MAIN cluster_features_5 :  cluster_features_4 mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */2 * * *" retry_on_failure="* */2 * * *" timeout="259200"

MAIN export_audience :  apply_models mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="0 * * * *" retry_on_failure="0 * * * *" timeout="86400"

MAIN build_time_hist_features :  time_hist_grep take_crypta_snapshot mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */2 * * *" retry_on_failure="* */2 * * *"

MAIN build_phone_range_features :  build_time_hist_features mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */2 * * *" retry_on_failure="* */2 * * *"

}

run_cmd(){
    echo $1
    $1
    echo ""
}

apply_models(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program apply_models"
}

build_contact_actions_features(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program build_contact_actions_features"
}

build_geo_aggregates(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program build_geo_aggregates"
}

build_geo_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program build_geo_logs"
}

build_phone_range_features(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program build_phone_range_features"
}

build_time_hist_features(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program build_time_hist_features"
}

check_crypta_stability(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program check_crypta_stability"
}

cluster_features_2(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program cluster_features_2"
}

cluster_features_3(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program cluster_features_3"
}

cluster_features_4(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program cluster_features_4"
}

cluster_features_5(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program cluster_features_5"
}

cluster_hostname_extract(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program cluster_hostname_extract"
}

contact_actions_grep(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program contact_actions_grep"
}

dssm_175(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program dssm_175"
}

dssm_175_combine(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program dssm_175_combine"
}

export_audience(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program export_audience"
}

grep_spy_watch_logs_extended(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program grep_spy_watch_logs_extended"
}

take_crypta_snapshot(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program take_crypta_snapshot"
}

time_hist_grep(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program time_hist_grep"
}

update_crypta_join_tables(){
run_cmd "$LAUNCHER --yt-token-name=robot_dc --program update_crypta_join_tables"
}

"$@"
