#! /bin/sh
set -e

# Start communism (shedulting helper for clustermaster)
/Berkanavt/communism/bin/solver -f -r -p 3366 -u /Berkanavt/communism/socket -l /Berkanavt/communism/solver.out -P /Berkanavt/communism/solver.pid &

# Start single clustermaster worker
/Berkanavt/clustermaster/bin/worker -f -v /Berkanavt/cm_workdir/worker/var -P /Berkanavt/cm_workdir/worker/pid &

# Force set all tasks to state "SUCCESS".
sh /Berkanavt/cm_workdir/task_starter.sh &

# Start clustermaster master process

if [ $CUSTOM_ENV = "DATACLOUD" ]; then
	# Run datacloud environment
    exec /Berkanavt/clustermaster/bin/master --panic -f -R -h 3130 -H 80 -s /Berkanavt/cm_workdir/datacloud_scenario.sh -v /Berkanavt/cm_workdir/master/var -P /Berkanavt/cm_workdir/master/pid
else
	# Run behaviour-triggers-yt environment
    exec /Berkanavt/clustermaster/bin/master --panic -f -R -h 3130 -H 80 -s /Berkanavt/cm_workdir/scenario.sh -v /Berkanavt/cm_workdir/master/var -P /Berkanavt/cm_workdir/master/pid
fi
