#!/bin/sh

CLUSTERMASTER_URL="http://x-prod-1.haze.yandex.net:3130/"

GIT_PATH=/Berkanavt/git/behavior-triggers-yt
ENV_PATH=$GIT_PATH/.env
KEYS_PATH=$([ -d "$HOME/.pykeymanager" ] && echo "$HOME/.pykeymanager" || echo "/etc/xprod-yt-pipeline/keys")

LAUNCHER_PATH="/xprod_launcher/app"

CLEANER_PATH=$([ -f "$ENV_PATH/bin/xprod-clear-tmp" ] && echo "$ENV_PATH/bin/xprod-clear-tmp" || echo "xprod-clear-tmp")
YT_WORK_CLUSTER=hahn
LAUNCHER_ARGS="--yt-cluster $YT_WORK_CLUSTER --use-yt-cfg --keys-path $KEYS_PATH"
LAUNCHER="$LAUNCHER_PATH $LAUNCHER_ARGS"
CLEANER="$CLEANER_PATH --keys-path $KEYS_PATH"

export YT_LOG_LEVEL=WARNING

_scenario() {
MAIN     = localhost res=cpu:0,mem:0 timeout=86400
SCATTER  = localhost worker1..worker2 res=cpu:0,mem:0 timeout=86400
SCATTER4 = localhost worker1..worker4 res=cpu:0,mem:0 timeout=86400
SCATTER8 = localhost worker1..worker8 res=cpu:0,mem:0 timeout=86400

MAIN merge_filtered_qloud_stream_logs :  mailto=re9ulusv,nryzhikov,penguin-diver

MAIN merge_filtered_services_stream_logs :  merge_filtered_qloud_stream_logs mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/20 * * * *" retry_on_failure="*/20 * * * *"

MAIN detect_ready_qloud_stream_logs :  mailto=re9ulusv,nryzhikov,penguin-diver

SCATTER4 grep_qloud_stream_logs :  detect_ready_qloud_stream_logs mailto=re9ulusv,nryzhikov,penguin-diver

MAIN detect_ready_services_stream_logs :  grep_qloud_stream_logs mailto=re9ulusv,nryzhikov,penguin-diver

MAIN unify_service_router_logs :  mailto=re9ulusv,nryzhikov,penguin-diver

MAIN check_all_days_in_the_month :  unify_service_router_logs mailto=re9ulusv,nryzhikov,penguin-diver

MAIN merge_unified_service_router_logs :  check_all_days_in_the_month mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/5 * * * *" retry_on_failure="*/5 * * * *"

MAIN build_score_api_aggregates :  unify_service_router_logs mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/10 * * * *" retry_on_failure="*/10 * * * *" timeout="86400"

SCATTER4 grep_services_stream_logs :  detect_ready_services_stream_logs mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/5 * * * *" retry_on_failure="*/5 * * * *"

MAIN detect_ready_datacloud_api_logs :  mailto=re9ulusv,nryzhikov,penguin-diver

MAIN upload_datacloud_api_logs :  detect_ready_datacloud_api_logs mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/5 * * * *" retry_on_failure="*/5 * * * *" timeout="259200"

MAIN detect_ready_router_stream_logs :  mailto=re9ulusv,nryzhikov,penguin-diver

MAIN upload_fast_logs_to_solomon :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* * * * *" retry_on_failure="* * * * *" timeout="600"

MAIN get_features_from_requests :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/5 * * * *" retry_on_failure="*/5 * * * *" timeout="86400"

MAIN new_money_calculation :  build_score_api_aggregates mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/10 * * * *" retry_on_failure="*/10 * * * *" timeout="86400"

MAIN process_fast_logs :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* * * * *" retry_on_failure="* * * * *" timeout="600"

MAIN compute_daily_stability :  get_features_from_requests mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/5 * * * *" retry_on_failure="*/5 * * * *" timeout="86400"

MAIN compute_segment_stability :  get_features_from_requests mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/5 * * * *" retry_on_failure="*/5 * * * *" timeout="86400"

MAIN upload_stability_to_ydb :  compute_daily_stability compute_segment_stability mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/5 * * * *" retry_on_failure="*/5 * * * *" timeout="86400"

MAIN merge_filtered_router_stream_logs :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/20 * * * *" retry_on_failure="*/20 * * * *"

MAIN calculate_stability_distribution_psi :  compute_daily_stability mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */4 * * *" retry_on_failure="* */4 * * *" timeout="86400"

MAIN get_test_features_from_requests :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */4 * * *" retry_on_failure="* */4 * * *" timeout="86400"

MAIN compute_test_segment_stability :  get_test_features_from_requests mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */4 * * *" retry_on_failure="* */4 * * *" timeout="86400"

MAIN compute_test_daily_stability :  get_test_features_from_requests mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */4 * * *" retry_on_failure="* */4 * * *" timeout="86400"

MAIN merge_fast_logs :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/20 * * * *" retry_on_failure="*/20 * * * *"

MAIN calculate_test_stability_distribution_psi :  compute_test_daily_stability mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */4 * * *" retry_on_failure="* */4 * * *" timeout="86400"

MAIN create_status_db_view :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* * * * *" retry_on_failure="* * * * *" timeout="300"

MAIN upload_router_logs_to_solomon :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/5 * * * *" retry_on_failure="*/5 * * * *" timeout="86400"

MAIN fast_logs_money :  mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="* */4 * * *" retry_on_failure="* */4 * * *" timeout="86400"

MAIN grep_router_stream_logs :  detect_ready_router_stream_logs mailto=re9ulusv,nryzhikov,penguin-diver restart_on_success="*/5 * * * *" retry_on_failure="*/5 * * * *"

}

run_cmd(){
    echo $1
    $1
    echo ""
}

build_score_api_aggregates(){
run_cmd "$LAUNCHER --yt-token-name=robot --program build_score_api_aggregates"
}

calculate_stability_distribution_psi(){
run_cmd "$LAUNCHER --yt-token-name=robot --program calculate_stability_distribution_psi"
}

calculate_test_stability_distribution_psi(){
run_cmd "$LAUNCHER --yt-token-name=robot --program calculate_test_stability_distribution_psi"
}

check_all_days_in_the_month(){
run_cmd "$LAUNCHER --yt-token-name=robot --program check_all_days_in_the_month"
}

compute_daily_stability(){
run_cmd "$LAUNCHER --yt-token-name=robot --program compute_daily_stability"
}

compute_segment_stability(){
run_cmd "$LAUNCHER --yt-token-name=robot --program compute_segment_stability"
}

compute_test_daily_stability(){
run_cmd "$LAUNCHER --yt-token-name=robot --program compute_test_daily_stability"
}

compute_test_segment_stability(){
run_cmd "$LAUNCHER --yt-token-name=robot --program compute_test_segment_stability"
}

create_status_db_view(){
run_cmd "$LAUNCHER --yt-token-name=robot --program create_status_db_view"
}

detect_ready_datacloud_api_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program detect_ready_datacloud_api_logs"
}

detect_ready_qloud_stream_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program detect_ready_qloud_stream_logs"
}

detect_ready_router_stream_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program detect_ready_router_stream_logs"
}

detect_ready_services_stream_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program detect_ready_services_stream_logs"
}

fast_logs_money(){
run_cmd "$LAUNCHER --yt-token-name=robot --program fast_logs_money"
}

get_features_from_requests(){
run_cmd "$LAUNCHER --yt-token-name=robot --program get_features_from_requests"
}

get_test_features_from_requests(){
run_cmd "$LAUNCHER --yt-token-name=robot --program get_test_features_from_requests"
}

grep_qloud_stream_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program grep_qloud_stream_logs"
}

grep_router_stream_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program grep_router_stream_logs"
}

grep_services_stream_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program grep_services_stream_logs"
}

merge_fast_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program merge_fast_logs"
}

merge_filtered_qloud_stream_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program merge_filtered_qloud_stream_logs"
}

merge_filtered_router_stream_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program merge_filtered_router_stream_logs"
}

merge_filtered_services_stream_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program merge_filtered_services_stream_logs"
}

merge_unified_service_router_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program merge_unified_service_router_logs"
}

new_money_calculation(){
run_cmd "$LAUNCHER --yt-token-name=robot --program new_money_calculation"
}

process_fast_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program process_fast_logs"
}

unify_service_router_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program unify_service_router_logs"
}

upload_datacloud_api_logs(){
run_cmd "$LAUNCHER --yt-token-name=robot --program upload_datacloud_api_logs"
}

upload_fast_logs_to_solomon(){
run_cmd "$LAUNCHER --yt-token-name=robot --program upload_fast_logs_to_solomon"
}

upload_router_logs_to_solomon(){
run_cmd "$LAUNCHER --yt-token-name=robot --program upload_router_logs_to_solomon"
}

upload_stability_to_ydb(){
run_cmd "$LAUNCHER --yt-token-name=robot --program upload_stability_to_ydb"
}

"$@"
