from util.generic.string cimport TString
from util.generic.vector cimport TVector


cdef extern from "datacloud/launcher/lib/grep/fast_grep.h" namespace "Datacloud::Grep" nogil:
    void fast_grep(const TString&, const TString&, const TString&) nogil
    void custom_fast_grep(
        const TString& yt_token, const TString& cluster,
        const TString& cryptaTable, const TVector[TString]& logTables,
        const TString& outputTable) nogil


cdef _grep(const TString& yt_token, const TString& cluster, const TString& date):
    with nogil:
        fast_grep(yt_token, cluster, date)


cdef _custom_grep(const TString& yt_token, const TString& cluster, const TString& cryptaTable, const TVector[TString]& logTables, const TString& outputTable):
    with nogil:
        custom_fast_grep(yt_token, cluster, cryptaTable, logTables, outputTable)


def grep(yt_token, date, cluster='hahn'):
    _grep(yt_token, cluster, date)


def custom_grep(yt_token, cluster, crypta_table, log_tables, output_table):
    _custom_grep(yt_token, cluster, crypta_table, log_tables, output_table)
