import os
import sys
from yt.wrapper import ypath_join
from library.python.nyt import client as nyt_client
from datacloud.config.yt import CRYPTA_DB_LAST_FOLDER
from datacloud.launcher.lib.grep import datacloud_grep
from datacloud.dev_utils.status_db.task import Task, Status
from datacloud.launcher.lib.grep import fast_grep


def sample_task():
    task = Task('sample_grep', '//user_sessions/pub/spy_log/daily/2019-05-13/clean',
                Status.READY,
                {
                    'date_str': '2019-05-13',
                    'table_path': '//user_sessions/pub/spy_log/daily/2019-05-13/clean',
                    'fast': True
                },
                '2019-05-12 11:00:00',
                '2019-05-12 11:00:00')
    datacloud_grep.grep_all_spy_watch_logs_extended(task)


def sample_custom_grep():
    yt_token = os.environ['YT_TOKEN']
    fast_grep.custom_grep(
        yt_token,
        'hahn',
        ypath_join(CRYPTA_DB_LAST_FOLDER, 'all_interesting_yuid'),
        (
            '//user_sessions/pub/watch_log_tskv/daily/2019-05-24/clean',
            '//user_sessions/pub/watch_log_tskv/daily/2019-05-25/clean',
        ),
        '//tmp/r9-fast-grep-output-month-v2'
    )


def main():
    # THIS LINE IS REQUIRED!
    nyt_client.initialize(sys.argv)
    sample_custom_grep()


if __name__ == '__main__':
    main()
