import random
from concurrent.futures import TimeoutError
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.dev_utils.yt import yt_utils
from datacloud.log_reader.lib.log_processor import FastLogProcessor


logger = get_basic_logger(__name__)
SCORE_API_FAST_TOPIC = '/datacloud/prod/score-api-fast-topic'
CONSUMER_ID = '/datacloud/prod/score-api-fast-consumer'

endpoints = [
    'man.logbroker.yandex.net',
    'myt.logbroker.yandex.net',
    'sas.logbroker.yandex.net',
    'vla.logbroker.yandex.net',
    'iva.logbroker.yandex.net',
]


def process_fast_logs():
    yt_client = yt_utils.get_yt_client()

    random.shuffle(endpoints)

    for endpoint in endpoints:
        logger.info('ENDPOINT {}'.format(endpoint))
        logger.info('Start process endpoint: {}'.format(endpoint))
        fast_log_processor = FastLogProcessor(
            yt_client, endpoint, SCORE_API_FAST_TOPIC, CONSUMER_ID)

        while True:
            logger.info('[FastLogsRoutine] Start log processing')
            try:
                fast_log_processor.process()
            except TimeoutError:
                logger.info('[FastLogsRoutine] No new logs found')
                break
        logger.info('Done with endpoint: {}\n\n'.format(endpoint))
    logger.info('Done.')
