# -*- coding: utf-8 -*-
import re
from yt.wrapper import ypath_split
from datacloud.dev_utils.yt.yt_utils import get_yt_client
from datacloud.dev_utils.time.patterns import RE_MONTH_LOG_FORMAT, RE_DAILY_LOG_FORMAT
from datacloud.money.qloud_logs.money_pipeline import calculate_money, RESPONSES
from datacloud.money.fast_logs.money_pipeline import calculate_fast_logs_money


def detect_ready_money(date_time, days=None):
    yt_client = get_yt_client()
    for table in yt_client.list(RESPONSES, absolute=True):
        date = ypath_split(table)[-1]
        if re.match(RE_DAILY_LOG_FORMAT, date) or re.match(RE_MONTH_LOG_FORMAT, date):
            yield table, {'table_path': table, 'date_str': date}


def run_calc_money(task):
    yt_client = get_yt_client()
    calculate_money(yt_client)

    return [task.make_done()]


def run_calc_fast_logs_money():
    yt_client = get_yt_client()
    calculate_fast_logs_money(yt_client)
