from yt.wrapper import ypath_join
import yt.wrapper as yt_wrapper

from datacloud.launcher.lib.services_logs.helpers import YqlLogFilter
from datacloud.log_reader.lib import table_schema
from datacloud.dev_utils.logging.logger import get_basic_logger


logger = get_basic_logger(__name__)


# TODO : Add merging of trash logs


class FastLogFilter(YqlLogFilter):
    """ Manipulates fast qloud log from x-products services """

    def __init__(self, *args, **kwargs):
        super(FastLogFilter, self).__init__()
        self._tables = FastLogTables(*args, **kwargs)

    def grep_stream_tables(self, table_pathes):
        raise NotImplementedError('ERROR: grep_stream_tables NOT IMPLEMENTED for FastLog')

    def list_unfiltered_stream(self):
        raise NotImplementedError('ERROR: list_unfiltered_stream NOT IMPLEMENTED for FastLog')

    def list_filtered_stream(self):
        # TODO: Update to fast logs
        yield self._tables.logs_history_path, self.yt_list(self._tables.raw_logs_stream_path)

    def get_yt_client(self):
        return self._tables.yt_client

    def get_stream_output_tables(self, time_str):
        raise NotImplementedError('ERROR: get_stream_output_tables NOT IMPLEMENTED for FastLog')
        # yield self._tables.get_raw_stream_table(time_str)


class FastLogTables:

    def __init__(self, root, **kwargs):
        self._root = root
        raw_logs_path = str(ypath_join(root, 'services/logs/datacloud_score_api/fast_logs/clean'))
        self.raw_logs_stream_path = str(ypath_join(raw_logs_path, 'stream'))
        self.logs_history_path = str(ypath_join(raw_logs_path, 'history'))

    def get_raw_stream_table(self, table_name):
        return yt_wrapper.TablePath(
            ypath_join(self.raw_logs_stream_path, table_name),
            attributes={
                'schema': table_schema.SCORE_API_LOG_TABLE
            }
        )
