from yt.wrapper import ypath_join
import yt.wrapper as yt_wrapper
from datacloud.launcher.lib.services_logs.helpers import YqlLogFilter
from datacloud.dev_utils.logging.logger import get_basic_logger


logger = get_basic_logger(__name__)


QLOUD_LOG_PATH = '//home/logfeller/logs/qloud-runtime-log'
QLOUD_LOG_SCHEMA = [
    {"name": "_logfeller_timestamp", "type": "uint64"},
    {"name": "iso_eventtime", "type": "string"},
    {"name": "level", "type": "int64"},
    {"name": "levelStr", "type": "string"},
    {"name": "loggerName", "type": "string"},
    {"name": "version", "type": "int64"},
    {"name": "fields", "type": "any"},
    {"name": "threadName", "type": "string"},
    {"name": "timestamp", "type": "string"},
    {"name": "qloud_project", "type": "string"},
    {"name": "qloud_application", "type": "string"},
    {"name": "qloud_environment", "type": "string"},
    {"name": "qloud_component", "type": "string"},
    {"name": "qloud_instance", "type": "string"},
    {"name": "message", "type": "string"},
    {"name": "host", "type": "string"},
    {"name": "stackTrace", "type": "string"},
    {"name": "source_uri", "type": "string"},
    {"name": "_stbx", "type": "string"},
]


class RawLogFilter(YqlLogFilter):
    """ Manipulates raw qloud log from x-products services """

    def __init__(self, *args, **kwargs):
        super(RawLogFilter, self).__init__()
        self._tables = QloudLogTables(*args, **kwargs)

    def grep_stream_tables(self, table_pathes):
        """ Filters table like "//home/logfeller/logs/qloud-runtime-log/stream/5min/2017-10-18T15:20:00" """
        query = """
            INSERT INTO `%(output_table)s`
            SELECT
                _logfeller_timestamp,
                iso_eventtime,
                level,
                levelStr,
                loggerName,
                version,
                fields,
                threadName,
                `timestamp`,
                qloud_project,
                qloud_application,
                qloud_environment,
                qloud_component,
                qloud_instance,
                message,
                host,
                stackTrace,
                source_uri,
                _stbx
            FROM `%(input_table)s`
            WHERE qloud_project = 'x-products' and qloud_application <> 'quasar-backend' and qloud_application <> 'quasmodrom';"""
        return super(RawLogFilter, self).grep_stream_tables(query, table_pathes)

    def list_unfiltered_stream(self):
        return self.yt_list(ypath_join(QLOUD_LOG_PATH, 'stream/5min'))

    def list_filtered_stream(self):
        yield self._tables.logs_history_path, self.yt_list(self._tables.raw_logs_stream_path)

    def get_yt_client(self):
        return self._tables.yt_client

    def get_stream_output_tables(self, time_str):
        yield self._tables.get_raw_stream_table(time_str)


class QloudLogTables:
    def __init__(self, root, **kwargs):
        self._root = root
        raw_logs_path = str(ypath_join(root, 'services/logs/qloud'))
        self.raw_logs_stream_path = str(ypath_join(raw_logs_path, 'stream/5min'))
        self.logs_history_path = str(ypath_join(raw_logs_path, 'history'))

    def get_raw_stream_table(self, table_name):
        return yt_wrapper.TablePath(
            ypath_join(self.raw_logs_stream_path, table_name),
            attributes={
                'schema': QLOUD_LOG_SCHEMA
            }
        )
