from datacloud.launcher.update_cm.lib.cm_task import cm_task


ROBOT = 'robot'
CRON_1M = '* * * * *'
CRON_1H = '0 * * * *'
CRON_2H = '* */2 * * *'
CRON_4H = '* */4 * * *'

DAY = 60 * 60 * 24
MINUTE = 60

_WORK_FOLDER = '//home/x-products/production'


@cm_task(robot=ROBOT, cron=CRON_1M, timeout=10*MINUTE)
def process_fast_logs(status_db, args):
    from datacloud.launcher.lib.routines.fast_logs_routine import process_fast_logs
    process_fast_logs()


@cm_task(robot=ROBOT)
def detect_ready_qloud_stream_logs(status_db, args):
    from datacloud.launcher.lib.services_logs.helpers import new_build_ready_detector
    from datacloud.launcher.lib.services_logs.qloud import RawLogFilter
    log_filter = RawLogFilter(_WORK_FOLDER)
    status_db.detect_ready('grep_qloud_stream_logs', new_build_ready_detector(log_filter.list_unfiltered_stream), args.date_hour_min, force=args.force)


@cm_task(robot=ROBOT, depends_on=[detect_ready_qloud_stream_logs], n_workers=4)
def grep_qloud_stream_logs(status_db, args):
    from datacloud.launcher.lib.services_logs.helpers import build_step_processor
    from datacloud.launcher.lib.services_logs.qloud import RawLogFilter
    log_filter = RawLogFilter(_WORK_FOLDER)
    status_db.run_task(args.program, build_step_processor(log_filter.grep_stream_tables, args.program))


@cm_task(robot=ROBOT, depends_on=[grep_qloud_stream_logs])
def detect_ready_services_stream_logs(status_db, args):
    from datacloud.launcher.lib.services_logs.helpers import new_build_ready_detector
    from datacloud.launcher.lib.services_logs.services import AllServicesLogFilter
    log_filter = AllServicesLogFilter(_WORK_FOLDER)
    status_db.detect_ready('grep_services_stream_logs', new_build_ready_detector(log_filter.list_unfiltered_stream), args.date_hour_min, force=args.force)


@cm_task(robot=ROBOT, depends_on=[detect_ready_services_stream_logs], n_workers=4,
         cron='*/5 * * * *')
def grep_services_stream_logs(status_db, args):
    from datacloud.launcher.lib.services_logs.helpers import build_step_processor
    from datacloud.launcher.lib.services_logs.services import AllServicesLogFilter
    log_filter = AllServicesLogFilter(_WORK_FOLDER)
    status_db.run_task(args.program, build_step_processor(log_filter.grep_stream_tables, args.program))


@cm_task(robot=ROBOT)
def merge_filtered_qloud_stream_logs(status_db, args):
    from datacloud.launcher.lib.services_logs.qloud import RawLogFilter
    log_filter = RawLogFilter(_WORK_FOLDER)
    log_filter.merge_history()


@cm_task(robot=ROBOT, depends_on=[merge_filtered_qloud_stream_logs],
         cron='*/20 * * * *')
def merge_filtered_services_stream_logs(status_db, args):
    from datacloud.launcher.lib.services_logs.services import AllServicesLogFilter
    log_filter = AllServicesLogFilter(_WORK_FOLDER)
    log_filter.update_events_last_ndays('datacloud_score_api', 'production')
    log_filter.merge_history()


# Start Router Logs Proccessing
@cm_task(robot=ROBOT)
def detect_ready_router_stream_logs(status_db, args):
    from datacloud.launcher.lib.services_logs.helpers import new_build_ready_detector
    from datacloud.launcher.lib.services_logs.router import RawLogFilterRouter
    log_filter = RawLogFilterRouter(_WORK_FOLDER)
    status_db.detect_ready('grep_router_stream_logs', new_build_ready_detector(log_filter.list_unfiltered_stream), args.date_hour_min, force=args.force)


@cm_task(robot=ROBOT, depends_on=[detect_ready_router_stream_logs],
         cron='*/5 * * * *')
def grep_router_stream_logs(status_db, args):
    from datacloud.launcher.lib.services_logs.helpers import build_step_processor
    from datacloud.launcher.lib.services_logs.router import RawLogFilterRouter
    log_filter = RawLogFilterRouter(_WORK_FOLDER)
    status_db.run_task(args.program, build_step_processor(log_filter.grep_stream_tables, args.program))


@cm_task(robot=ROBOT, cron='*/20 * * * *')
def merge_filtered_router_stream_logs(status_db, args):
    from datacloud.launcher.lib.services_logs.router import RawLogFilterRouter
    log_filter = RawLogFilterRouter(_WORK_FOLDER)
    log_filter.merge_history()
# End Router Logs Proccssing


# Fast logs processing
@cm_task(robot=ROBOT, cron='*/20 * * * *')
def merge_fast_logs(status_db, args):
    from datacloud.launcher.lib.services_logs.fast import FastLogFilter
    log_filter = FastLogFilter(_WORK_FOLDER)
    log_filter.merge_history()
# End fast logs processing


@cm_task(robot=ROBOT)
def unify_service_router_logs(status_db, args):
    from datacloud.launcher.lib.routines.logs2answer_table import run_unify_router_and_qloud, detect_ready_service_and_router_logs
    status_db.detect_ready(args.program, detect_ready_service_and_router_logs, args.date_hour_min, force=args.force)
    status_db.run_task(args.program, run_unify_router_and_qloud)


@cm_task(robot=ROBOT, depends_on=[unify_service_router_logs])
def check_all_days_in_the_month(status_db, args):
    from datacloud.launcher.lib.routines.logs2answer_table import check_all_days_in_the_month
    check_all_days_in_the_month()


@cm_task(robot=ROBOT, depends_on=[check_all_days_in_the_month], cron='*/5 * * * *')
def merge_unified_service_router_logs(status_db, args):
    from datacloud.launcher.lib.routines.logs2answer_table import merge_response_logs
    merge_response_logs()


@cm_task(robot=ROBOT, depends_on=[unify_service_router_logs], cron='*/10 * * * *',
         timeout=DAY)
def build_score_api_aggregates(status_db, args):
    from datacloud.launcher.lib.routines.score_api_aggregates_routine import build_score_api_aggregates
    build_score_api_aggregates()


@cm_task(robot=ROBOT, depends_on=[build_score_api_aggregates], cron='*/10 * * * *',
         timeout=DAY)
def new_money_calculation(status_db, args):
    from datacloud.launcher.lib.routines.money import detect_ready_money, run_calc_money
    status_db.detect_ready(args.program, detect_ready_money, args.date_hour_min, force=args.force)
    status_db.run_task(args.program, run_calc_money)


@cm_task(robot=ROBOT, cron='* */4 * * *', timeout=DAY)
def fast_logs_money(status_db, args):
    from datacloud.launcher.lib.routines.money import run_calc_fast_logs_money
    run_calc_fast_logs_money()


# start upload-5min-api-logs
@cm_task(robot=ROBOT)
def detect_ready_datacloud_api_logs(status_db, args):
    from datacloud.launcher.lib.routines import datacloud_api_solomon
    status_db.detect_ready('detect_ready_datacloud_api_logs', datacloud_api_solomon.detect_ready_api_stream_logs, args.date_hour_min, force=args.force)


@cm_task(robot=ROBOT, depends_on=[detect_ready_datacloud_api_logs],
         cron='*/5 * * * *', timeout=3*DAY)
def upload_datacloud_api_logs(status_db, args):
    from datacloud.launcher.lib.routines import datacloud_api_solomon
    status_db.run_task('detect_ready_datacloud_api_logs', datacloud_api_solomon.run_upload_table_to_solomon)
# end upluad-5min-api-logs


@cm_task(robot=ROBOT, cron='*/5 * * * *', timeout=DAY)
def upload_router_logs_to_solomon(status_db, args):
    from datacloud.launcher.lib.routines.router_logs2solomon import detect_router_logs_to_solomon
    from datacloud.launcher.lib.routines.router_logs2solomon import run_upload_router_logs_to_solomon
    status_db.detect_ready(args.program, detect_router_logs_to_solomon, args.date_hour_min, force=args.force)
    status_db.run_task(args.program, run_upload_router_logs_to_solomon)


@cm_task(robot=ROBOT, cron='*/5 * * * *', timeout=DAY)
def get_features_from_requests(status_db, args):
    from datacloud.launcher.lib.routines.stability_routine import run_get_features_from_requests, detect_ready_compute_stability
    status_db.detect_ready(args.program, detect_ready_compute_stability, args.date_hour_min, force=args.force)
    status_db.run_task(args.program, run_get_features_from_requests)


@cm_task(robot=ROBOT, depends_on=[get_features_from_requests],
         cron='*/5 * * * *', timeout=DAY)
def compute_daily_stability(status_db, args):
    from datacloud.launcher.lib.routines.stability_routine import run_compute_daily_stability
    status_db.run_task(args.program, run_compute_daily_stability)


@cm_task(robot=ROBOT, depends_on=[get_features_from_requests], cron='*/5 * * * *',
         timeout=DAY)
def compute_segment_stability(status_db, args):
    from datacloud.launcher.lib.routines.stability_routine import run_compute_segment_stability
    status_db.run_task(args.program, run_compute_segment_stability)


@cm_task(robot=ROBOT, depends_on=[compute_daily_stability, compute_segment_stability],
         cron='*/5 * * * *', timeout=DAY)
def upload_stability_to_ydb(status_db, args):
    from datacloud.launcher.lib.routines.stability_routine import run_upload_stability_to_ydb
    status_db.run_task(args.program, run_upload_stability_to_ydb)


# Start feature PSI stability control
@cm_task(robot=ROBOT, cron='* */4 * * *', timeout=DAY)
def get_test_features_from_requests(status_db, args):
    from datacloud.launcher.lib.routines.stability_routine import detect_ready_compute_test_stability, run_get_test_features_from_requests
    status_db.detect_ready(args.program, detect_ready_compute_test_stability, args.date_hour_min)
    status_db.run_task(args.program, run_get_test_features_from_requests)


@cm_task(robot=ROBOT, depends_on=[get_test_features_from_requests],
         cron='* */4 * * *', timeout=DAY)
def compute_test_segment_stability(status_db, args):
    from datacloud.launcher.lib.routines.stability_routine import run_compute_test_segment_stability
    status_db.run_task(args.program, run_compute_test_segment_stability)


@cm_task(robot=ROBOT, depends_on=[get_test_features_from_requests],
         cron='* */4 * * *', timeout=DAY)
def compute_test_daily_stability(status_db, args):
    from datacloud.launcher.lib.routines.stability_routine import run_compute_test_daily_stability
    status_db.run_task(args.program, run_compute_test_daily_stability)


@cm_task(robot=ROBOT, depends_on=[compute_test_daily_stability],
         cron='* */4 * * *', timeout=DAY)
def calculate_test_stability_distribution_psi(status_db, args):
    from datacloud.launcher.lib.routines.stability_routine import run_calculate_test_stability_distribution_psi
    status_db.run_task(args.program, run_calculate_test_stability_distribution_psi)
# End feature PSI stability control


@cm_task(robot=ROBOT, depends_on=[compute_daily_stability],
         cron='* */4 * * *', timeout=DAY)
def calculate_stability_distribution_psi(status_db, args):
    from datacloud.launcher.lib.routines.stability_routine import run_calculate_stability_distribution_psi
    status_db.run_task(args.program, run_calculate_stability_distribution_psi)


@cm_task(robot=ROBOT, cron=CRON_1M, timeout=10*MINUTE)
def upload_fast_logs_to_solomon(status_db, args):
    from datacloud.launcher.lib.routines.fast_logs_solomon_upload import (
        upload_to_solomon, detect_ready)
    status_db.detect_ready(args.program, detect_ready, args.date_hour_min)
    status_db.run_task(args.program, upload_to_solomon)


@cm_task(robot=ROBOT, cron=CRON_1M, timeout=5*MINUTE)
def create_status_db_view(status_db, args):
    from datacloud.launcher.lib.routines import status_db_viewer_routine
    status_db_viewer_routine.create_status_db_view()
