

template = """#!/bin/sh

CLUSTERMASTER_URL="http://x-prod-1.haze.yandex.net:3130/"

GIT_PATH=/Berkanavt/git/behavior-triggers-yt
ENV_PATH=$GIT_PATH/.env
KEYS_PATH=$([ -d "$HOME/.pykeymanager" ] && echo "$HOME/.pykeymanager" || echo "/etc/xprod-yt-pipeline/keys")

LAUNCHER_PATH="/xprod_launcher/app"

CLEANER_PATH=$([ -f "$ENV_PATH/bin/xprod-clear-tmp" ] && echo "$ENV_PATH/bin/xprod-clear-tmp" || echo "xprod-clear-tmp")
YT_WORK_CLUSTER=hahn
LAUNCHER_ARGS="--yt-cluster $YT_WORK_CLUSTER --use-yt-cfg --keys-path $KEYS_PATH"
LAUNCHER="$LAUNCHER_PATH $LAUNCHER_ARGS"
CLEANER="$CLEANER_PATH --keys-path $KEYS_PATH"

export YT_LOG_LEVEL=WARNING

_scenario() {{
MAIN     = localhost res=cpu:0,mem:0 timeout=86400
SCATTER  = localhost worker1..worker2 res=cpu:0,mem:0 timeout=86400
SCATTER4 = localhost worker1..worker4 res=cpu:0,mem:0 timeout=86400
SCATTER8 = localhost worker1..worker8 res=cpu:0,mem:0 timeout=86400

{full_declaration}

}}

run_cmd(){{
    echo $1
    $1
    echo ""
}}

{full_definition}

"$@"
"""
