

MAIL_TO = 're9ulusv,nryzhikov,penguin-diver'


class CMData(object):
    def __init__(self, program_name, depends_on, on_success, on_failure,
                 robot, timeout, mailto, n_workers):
        self.program_name = program_name
        self.depends_on = depends_on
        self.on_success = on_success
        self.on_failure = on_failure
        self.robot = robot
        self.timeout = timeout
        self.mailto = mailto
        self.n_workers = n_workers


def cm_task(
        robot,
        program_name=None,
        depends_on=None,
        cron=None,
        on_success=None, on_failure=None,
        timeout=None, mailto=MAIL_TO,
        n_workers=1):

    depends_on = depends_on or []
    if cron and (on_success or on_failure):
        raise 'Use `cron` OR (`on_succes` with `on_failure`), not both'

    assert n_workers in [1, 2, 4, 8], 'n_workers must be in [1, 2, 4, 8]'

    if cron:
        on_success = cron
        on_failure = cron

    def decorator(func):
        func.is_cm_task = True
        func.cm_data = CMData(
            program_name=program_name or func.__name__,
            depends_on=depends_on,
            on_success=on_success,
            on_failure=on_failure,
            robot=robot,
            timeout=timeout,
            mailto=mailto,
            n_workers=n_workers
        )
        return func

    return decorator
