import time
from concurrent.futures import TimeoutError
from datacloud.dev_utils.yt import yt_utils
from datacloud.log_reader.lib.log_processor import FastLogProcessor


def main():
    time_to_sleep = 5
    topic = '/datacloud/test/demo-topic'
    consumer_id = '/datacloud/test/demo-consumer'
    yt_client = yt_utils.get_yt_client()
    fast_log_processor = FastLogProcessor(yt_client, topic, consumer_id)
    while True:
        try:
            fast_log_processor.process()
        except TimeoutError:
            print('TimeOut, sleep {} seconds'.format(time_to_sleep))
            time.sleep(time_to_sleep)


if __name__ == '__main__':
    main()
