from datacloud.log_reader.lib import (
    log_reader, log_writer
)
from datacloud.dev_utils.logging.logger import get_basic_logger

logger = get_basic_logger(__name__)


class LogProcessor(object):
    pass


class FastLogProcessor(LogProcessor):
    def __init__(self, yt_client, endpoint, topic, consumer_id, batch_size=100,
                 timeout=5):
        self._yt_client = yt_client
        self._endpoint = endpoint
        self._topic = topic
        self._consumer_id = consumer_id
        self._batch_size = batch_size
        self._timeout = timeout

        self._clean_writer = log_writer.get_clean_log_writer(
            self._yt_client
        )
        self._trash_writer = log_writer.get_trash_log_writer(
            self._yt_client
        )

    def process(self):
        logger.info('Start FastLogPorcessor.process')
        consumer = log_reader.LogBrokerConsumer(self._endpoint, self._topic, self._consumer_id)
        data = consumer.read(self._batch_size, self._timeout)
        clear_data, trash_data = [], []
        for rec in data:
            if rec[1]:
                clear_data.append(rec[0])
            else:
                trash_data.append(rec[0])
        self._clean_writer.write(clear_data)
        self._trash_writer.write(trash_data)
        consumer.commit()
        logger.info('Finish FastLogProcessor.process')
