import time
from contextlib import contextmanager


__all__ = [
    'timer',
]


@contextmanager
def timer():
    """ Helper for time measurements """
    start_time = time.time()

    def get_value():
        return time.time() - start_time

    yield get_value
