# -*- coding: utf-8 -*-
import calendar
from datetime import datetime
from datacloud.dev_utils.yt import yt_config_table
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.dev_utils.time.patterns import FMT_DATE_HMST

logger = get_basic_logger(__name__)
DEFAULT_PATH = '//home/x-products/benchmarks/benchmark_results'


__all__ = [
    'BenchmarkResultsTable'
]


class BenchmarkResultsTable(yt_config_table.ConfigTable):
    def __init__(self, table_path=DEFAULT_PATH, yt_client=None):
        schema = [
            {'name': 'reverse_ts', 'type': 'int64', 'sort_order': 'ascending'},
            {'name': 'ts_hr_format', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'ticket', 'type': 'string', 'sort_order': 'ascending'},
            {'name': 'nirvana_graph', 'type': 'string'},
            {'name': 'description', 'type': 'string'},
            {'name': 'auc', 'type': 'any'},
            {'name': 'auc_on_cs', 'type': 'any'},
            {'name': 'std', 'type': 'any'},
            {'name': 'std_on_cs', 'type': 'any'},
            {'name': 'additional', 'type': 'any'},
        ]
        super(BenchmarkResultsTable, self).__init__(
            table_path, schema, yt_client
        )

    def add_record(self, ts_hr_format, ticket, nirvana_graph, description, auc, auc_on_cs,
                   std, std_on_cs, additional=None):
        dt = datetime.strptime(ts_hr_format, FMT_DATE_HMST)
        reverse_ts = -1 * calendar.timegm(dt.utctimetuple())
        additional = additional or {}

        record = {
            'reverse_ts': reverse_ts,
            'ts_hr_format': ts_hr_format,
            'ticket': ticket,
            'nirvana_graph': nirvana_graph,
            'description': description,
            'auc': auc,
            'auc_on_cs': auc_on_cs,
            'std': std,
            'std_on_cs': std_on_cs,
            'additional': additional
        }
        self.insert_records([record])
