# -*- coding: utf-8 -*-
import calendar
from datetime import datetime
from datacloud.dev_utils.solomon.solomon_utils import post_sensors_to_solomon, TIMESHIFT
from datacloud.dev_utils.time.patterns import FMT_DATE_HMST

SOLOMON_PROJECT = 'datacloud'
SOLOMON_CLUSTER = 'benchmark'
SOLOMON_SERVICE = 'blessed-benchmarks'
VALUE_TYPES = set(('auc', 'std'))


def make_sensor(ts_hr_format, ts_seconds, dataset_name, value, value_type,
                is_on_cs, description):
    assert value_type in VALUE_TYPES, 'Bad value type {}'.format(value_type)
    assert type(is_on_cs) is bool

    return {
        'labels': {
            'ts': ts_hr_format,
            'dataset_name': dataset_name,
            'value_type': value_type,
            'is_on_cs': is_on_cs,
            'description': description
        },
        'ts': ts_seconds,
        'value': value
    }


def sensors_generator(ts_hr_format, ts_seconds, value_type, is_on_cs, values_dict,
                      description):
    for dataset_name, value in values_dict.iteritems():
        yield make_sensor(ts_hr_format, ts_seconds, dataset_name, value,
                          value_type, is_on_cs, description)


def upload_bm_to_solomon(ts_hr_format, ticket, nirvana_graph, description, auc,
                         auc_on_cs, std, std_on_cs):
    dt = datetime.strptime(ts_hr_format, FMT_DATE_HMST)
    ts_seconds = calendar.timegm(dt.utctimetuple()) + TIMESHIFT

    sensors = []
    sensors.extend(
        sensors_generator(ts_hr_format, ts_seconds, 'auc', False, auc, description))
    sensors.extend(
        sensors_generator(ts_hr_format, ts_seconds, 'std', False, std, description))
    sensors.extend(
        sensors_generator(ts_hr_format, ts_seconds, 'auc', True, auc_on_cs, description))
    sensors.extend(
        sensors_generator(ts_hr_format, ts_seconds, 'std', True, std_on_cs, description))

    post_sensors_to_solomon(SOLOMON_PROJECT, SOLOMON_CLUSTER, SOLOMON_SERVICE, sensors)
