import numpy as np
import pandas as pd


def psi(target, reference, eps=1e-9, bins_num=10):
    _, bins = pd.qcut(np.concatenate((target, reference)), bins_num, retbins=True)

    target, _ = np.histogram(target, bins=bins, density=True)
    target = target / float(np.sum(target))
    reference, _ = np.histogram(reference, bins=bins, density=True)
    reference = reference / float(np.sum(reference))
    return np.sum((target - reference) * np.log((target + eps) / (reference + eps)))
