# -*- coding: utf-8 -*-
import inspect
from abc import ABCMeta, abstractmethod


class ReprMixin:
    __metaclass__ = ABCMeta

    @abstractmethod
    def __init__(self):
        pass

    def __repr__(self):
        def make_params_str():
            args = inspect.getargspec(self.__init__)[0]
            args.remove('self')
            args = [(arg, getattr(self, arg)) for arg in args]
            args_strings = ['{}={}'.format(arg[0], arg[1]) for arg in args]
            return ', '.join(args_strings)

        return '{}({})'.format(
            self.__class__.__name__,
            make_params_str()
        )
