from yt.wrapper import ypath_join, TablePath


class PathConfig:
    def __init__(self, cconfig):
        self.aggs_folder = cconfig.aggs_folder

        self.path_to_cse = ypath_join(self.aggs_folder, 'credit_scoring_events')
        self.clean_cse_path = ypath_join(self.aggs_folder, 'clean_cse')
        self.cse_interesting_eids = ypath_join(self.aggs_folder, 'cse_interesting_eids')

        self.zeros_table = ypath_join(self.aggs_folder, 'zeros_table')
        self.ones_table = ypath_join(self.aggs_folder, 'ones_table')
        self.eids_table = ypath_join(self.aggs_folder, 'eids')

        self.id_value_to_cid = ypath_join(self.aggs_folder, 'id_value_to_cid')
        self.phone_id_value_to_cid = ypath_join(self.aggs_folder, 'phone_id_value_to_cid')
        self.email_id_value_to_cid = ypath_join(self.aggs_folder, 'email_id_value_to_cid')
        self.cid_to_all = ypath_join(self.aggs_folder, 'cid_to_all')

        self.eid2cid = ypath_join(self.aggs_folder, 'eid2cid')
        self.eid2mark = TablePath(
            ypath_join(self.aggs_folder, 'eid2mark'),
            schema=[
                {'name': 'external_id', 'type': 'string'},
                {'name': 'mark', 'type': 'string'},
            ]
        )

    def make_cse_table(self, suffix):
        return ypath_join(self.aggs_folder, 'cse_{}'.format(str(suffix)))

    def make_cse_compacted_table(self, suffix):
        cse_compacted_schema = [
            {'name': 'external_id', 'type': 'string'},
            {'name': 'retro_date', 'type': 'string'},
            {'name': 'email_id_value', 'type': 'string'},
            {'name': 'phone_id_value', 'type': 'string'},
            {'name': 'partner', 'type': 'string'},
            {'name': 'target', 'type': 'int64'},
        ]
        return TablePath(
            ypath_join(self.aggs_folder, 'cse_compacted_{}'.format(str(suffix))),
            schema=cse_compacted_schema
        )
