# -*- coding: utf-8 -*-
from yt.wrapper import ypath_join, TablePath
from datacloud.ml_utils.dolphin.prepare_logs.helpers import DEFAULT_SUFFIX


class PathConfig:
    def __init__(self, plconfig):
        self.exp_folder = plconfig.exp_folder
        self.brew_folder = plconfig.brew_folder

        grep_folder = ypath_join(plconfig.pipeline_folder, 'datacloud', 'grep')
        spy_log = ypath_join(grep_folder, 'spy_log', 'spy_log')
        watch_log = ypath_join(grep_folder, 'watch_log_tskv', 'watch_log_tskv')
        self.logs_tables = [spy_log, watch_log]
        self.eid_target = ypath_join(plconfig.pipeline_folder, 'raw_data', 'glued')

        self.filtred = TablePath(
            ypath_join(self.brew_folder, 'filtred'),
            schema=[
                {'name': 'external_id', 'type': 'string'},
                {'name': 'yuid', 'type': 'string'},
                {'name': 'timestamp', 'type': 'int64'},
                {'name': 'title', 'type': 'string'},
                {'name': 'url', 'type': 'string'},
            ]
        )

        self.input_yuid = ypath_join(plconfig.pipeline_folder, 'input_yuid')
        self.eid2mark = TablePath(
            ypath_join(plconfig.brew_folder, 'marked_eids'),
            schema=[
                {'name': 'external_id', 'type': 'string'},
                {'name': 'mark', 'type': 'string'},
            ]
        )

    def applied(self, suffix=DEFAULT_SUFFIX):
        return ypath_join(self.brew_folder, 'applied_{}'.format(suffix))

    def dssm_tensors(self, suffix=DEFAULT_SUFFIX):
        return TablePath(
            ypath_join(self.brew_folder, 'dssm_tensors_{}'.format(suffix)),
            schema=[
                {'name': 'external_id', 'type': 'string'},
                {'name': 'history', 'type': 'string'},
                {'name': 'random', 'type': 'double'},
                {'name': 'fake_category', 'type': 'string'},
                {'name': 'target', 'type': 'int64'}
            ]
        )

    def torch_grouped(self, suffix=DEFAULT_SUFFIX):
        return TablePath(
            ypath_join(self.brew_folder, 'torch_grouped_{}'.format(suffix)),
            schema=[
                {'name': 'external_id', 'type': 'string'},
                {'name': 'embs', 'type': 'any'},
                {'name': 'random', 'type': 'double'},
                {'name': 'target', 'type': 'int64'}
            ]
        )

    def torch_brewed(self, suffix=DEFAULT_SUFFIX):
        return ypath_join(self.brew_folder, 'torch_brewed_{}'.format(suffix))
