# -*- coding: utf-8 -*-
import joblib
import sys
import os

BASE_DIR = os.path.dirname(os.path.abspath(__file__))


def print_feature_names(feature_list, dssm2index, id2query):
    count = 0
    for i in feature_list:
        count += 1
        if i < 400:
            print '{}th DSSM feature by query: {} '.format(count, dssm2index[i])
        else:
            print '{}th Cluster feature category: {} '.format(count, id2query[i - 400])


if __name__ == '__main__':
    features = map(int, sys.argv[1:])
    cluster_list = joblib.load(os.path.join(BASE_DIR, 'cluster_dict.pikle'))
    dssm_list = joblib.load(os.path.join(BASE_DIR, 'dssm_dict.pikle'))
    print_feature_names(features, dssm_list, cluster_list)
