# -*- coding: utf-8 -*-
import json
import numpy as np
import sys

from datacloud.dev_utils.logging.logger import get_nirvana_logger
from datacloud.ml_utils.common.constants import RANDOM_SEED
from datacloud.ml_utils.grid_search_wrapper.nirvana_cube.run_cube_with_params import run_cube_with_params

np.random.seed(RANDOM_SEED)
logger = get_nirvana_logger(__name__)


if __name__ == '__main__':
    logger.info('Hello, let\'s begin')

    with open(sys.argv[1]) as f:
        params = json.load(f)

    result = run_cube_with_params(params, logger)

    with open(sys.argv[2], 'wb') as out_json:
        out_json.write(json.dumps(result))

