# -*- coding: utf-8 -*-
import numpy as np
from sklearn.model_selection import GridSearchCV
from sklearn.linear_model import LogisticRegression

clf = LogisticRegression()
grid_params = {'C': np.logspace(-5,5,5)}
gs = GridSearchCV(clf, grid_params, cv=5, scoring='roc_auc', n_jobs=5)
N = 1000
X = np.random.random((N,20))
z = X[:,:2].sum(axis=1)  + 2.0*(np.random.random((N,))-1)
y = (z/2.0 > 0.5).astype(int)
gs.fit(X, y)
print gs.cv_results_['mean_test_score']
print gs.cv_results_['mean_train_score']