PY2_LIBRARY()

OWNER(g:xprod)

PY_SRCS(
    common/constants.py
    common/repr_mixin.py
    common/metrics.py

    crossval_utils/OOF_predictions.py

    jupyter_utils/data_loading.py

    grid_search_wrapper/cv_with_default_params.py
    grid_search_wrapper/grid_search_runner.py
    grid_search_wrapper/models_with_default_params.py
    grid_search_wrapper/nirvana_cube/load_table.py
    grid_search_wrapper/nirvana_cube/run_cube_with_params.py

    vh_wrapper/graph_builder.py
    vh_wrapper/helpers/cubes.py
)

PEERDIR(
    contrib/python/numpy
    contrib/python/scipy
    contrib/python/scikit-learn
    contrib/python/pandas
    contrib/python/tqdm

    datacloud/dev_utils
    datacloud/dev_utils/data
    datacloud/key_manager

    library/python/nirvana_api
    nirvana/valhalla/src
)

END()

RECURSE(
    vh_wrapper/helpers
    grid_search_wrapper/nirvana_cube
    kmeans
    benchmark
    benchmark_v2
    dolphin
    visual_utils
)
