import sys
import click
from datacloud.dev_utils.yt import yt_utils
from datacloud.dev_utils.logging.logger import get_basic_logger
from datacloud.model_applyer.tables.models_config_table import ApiModelsConfigTable

logger = get_basic_logger(__name__)


@click.group()
def cli():
    pass


@cli.command('delete-model')
@click.option('--partner-id', required=True)
@click.option('--score-name', required=True)
def remove_model(partner_id, score_name):
    yt_client = yt_utils.get_yt_client()
    config = ApiModelsConfigTable(yt_client=yt_client)
    model = config.get_model(partner_id, score_name)
    if model is None:
        logger.info('Model {}/{} not found'.format(partner_id, score_name))
        sys.exit(1)
    if click.confirm('Remove model {}?'.format(model)):
        config.remove_model(partner_id, score_name)
        logger.info('Done')


@cli.command('turn-off')
@click.option('--partner-id', required=True)
@click.option('--score-name', required=True)
def turn_off(partner_id, score_name):
    yt_client = yt_utils.get_yt_client()
    config = ApiModelsConfigTable(yt_client=yt_client)
    config.turn_off(partner_id, score_name)
    logger.info('Done. Model {} {} if OFF'.format(partner_id, score_name))


@cli.command('turn-on')
@click.option('--partner-id', required=True)
@click.option('--score-name', required=True)
def turn_on(partner_id, score_name):
    yt_client = yt_utils.get_yt_client()
    config = ApiModelsConfigTable(yt_client=yt_client)
    config.turn_on(partner_id, score_name)
    logger.info('Done. Model {} {} if ON.'.format(partner_id, score_name))


if __name__ == '__main__':
    cli()
